/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.europa;

import com.bizunited.nebula.europa.sdk.service.strategy.PersonalizationTemplateStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.PersonalizationTemplateVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="defaultRoleByPersonalizationTemplateStrategy")
public class DefaultRoleByPersonalizationTemplateStrategy
implements PersonalizationTemplateStrategy {
    private static final String ROLE_NAME = "role";
    private Map<String, String> cached = Maps.newLinkedHashMap();

    public int getOrder() {
        return 2;
    }

    public String getName() {
        return ROLE_NAME;
    }

    public String getDescription() {
        return "\u6309\u89d2\u8272\u8bbe\u5b9a";
    }

    public void onMappingCreate(EuropaInfoVo europaInfoVo, PersonalizationTemplateVo personalizationTemplateVo, String key, String value) {
        String[] roleCodes;
        String europaInfoCode = europaInfoVo.getCode();
        String personalizationTemplateCode = personalizationTemplateVo.getCode();
        for (String roleCode : roleCodes = StringUtils.split((String)value, (String)",")) {
            String cacheKey = StringUtils.join((Object[])new String[]{roleCode, "_", europaInfoCode, "_", personalizationTemplateCode});
            this.cached.put(cacheKey, cacheKey);
        }
    }

    public void onMappingModify(EuropaInfoVo europaInfoVo, PersonalizationTemplateVo personalizationTemplateVo, String key, String value) {
        this.onMappingCreate(europaInfoVo, personalizationTemplateVo, key, value);
    }

    public void onMappingDelete(EuropaInfoVo europaInfoVo, PersonalizationTemplateVo personalizationTemplateVo, String key, String oldvValue) {
        String[] roleCodes;
        String europaInfoCode = europaInfoVo.getCode();
        String personalizationTemplateCode = personalizationTemplateVo.getCode();
        for (String roleCode : roleCodes = StringUtils.split((String)oldvValue, (String)",")) {
            String cacheKey = StringUtils.join((Object[])new String[]{roleCode, "_", europaInfoCode, "_", personalizationTemplateCode});
            this.cached.remove(cacheKey);
        }
    }

    public String onRequestByAccount(PersonalizationTemplateVo personalizationTemplateVo, String tenantCode, String account, String key) {
        String europaInfoCode = personalizationTemplateVo.getEuropaInfoCode();
        String personalizationTemplateCode = personalizationTemplateVo.getCode();
        String findKey = StringUtils.join((Object[])new String[]{"_", europaInfoCode, "_", personalizationTemplateCode});
        Set<Map.Entry<String, String>> entrySet = this.cached.entrySet();
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<String, String> entry : entrySet) {
            String entryKey = entry.getKey();
            int index = StringUtils.lastIndexOf((CharSequence)entryKey, (CharSequence)findKey);
            if (index == -1) continue;
            String role = StringUtils.substring((String)entryKey, (int)0, (int)index);
            arrayList.add(role);
        }
        if (CollectionUtils.isEmpty((Collection)arrayList)) {
            return null;
        }
        CharSequence[] roles = arrayList.toArray(new String[0]);
        if (!StringUtils.equalsAny((CharSequence)"ADMIN", (CharSequence[])roles)) {
            return null;
        }
        return "ADMIN";
    }

    public String onRequest(PersonalizationTemplateVo personalizationTemplateVo, String tenantCode, String key) {
        String europaInfoCode = personalizationTemplateVo.getEuropaInfoCode();
        String personalizationTemplateCode = personalizationTemplateVo.getCode();
        String findKey = StringUtils.join((Object[])new String[]{"_", europaInfoCode, "_", personalizationTemplateCode});
        Set<Map.Entry<String, String>> entrySet = this.cached.entrySet();
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<String, String> entry : entrySet) {
            String entryKey = entry.getKey();
            int index = StringUtils.lastIndexOf((CharSequence)entryKey, (CharSequence)findKey);
            if (index == -1) continue;
            String role = StringUtils.substring((String)entryKey, (int)0, (int)index);
            arrayList.add(role);
        }
        if (CollectionUtils.isEmpty((Collection)arrayList)) {
            return null;
        }
        return StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)",");
    }
}

