package com.bizunited.nebula.rbac.sdk.event;

import com.bizunited.nebula.rbac.sdk.vo.RoleVo;

/**
 * 角色事件监听，凡是需要在角色关键逻辑过程中进行干预的模块，都需要实现该接口</p>
 * 并注入到IOC容器中
 * @author yinwenjie
 *
 */
public interface RoleEventListener {
  /**
   * 当角色被创建时，该事件被触发。</br>
   * 如果监听者由于出于业务完整性的考虑，不允许指定角色的创建，则可以直接在实现方法中抛出异常即可
   * @param role
   */
  public void onCreated(RoleVo role);
  
  /**
   * 该方法在2022-12-15 进行的添加，为了简化二次开发工作，直接在方法中提供了oldRole这个修改前的角色信息（只包括基本信息）</br>
   * 注意：如果没有特别要求，建议二开团队实现onUpdate(RoleVo)方法。另外，无论怎样，两个onUpdate方法只允许实现一个，否则onUpdate(RoleVo)方法的实现会失效
   * @param newRole 修改后的角色信息
   * @param oldRole 修改前的角色信息
   */
  public default void onUpdate(RoleVo newRole , RoleVo oldRole) {
    onUpdate(newRole);
  }
  /**
   * 当角色信息被修改时，该事件被触发</br>
   * 注意，返回的参数是修改后的角色信息，但是，由于修改过程中code信息不可修改，所以实际上可以在缓存中找到修改前的缓存角色信息
   * @param newRole 修改后的角色信息
   */
  public void onUpdate(RoleVo newRole);
  /**
   * 当角色被删除时，该事件被触发。</br>
   * 如果监听者由于出于业务完整性的考虑，不允许指定角色的删除，则可以直接在实现方法中抛出异常即可
   * @param role
   */
  public void onDeleted(RoleVo role);
}