package com.bizunited.nebula.rbac.sdk.event;

import java.util.List;

/**
 * 角色关联注册（向上），凡是需要在角色关键逻辑过程中进行干预的模块，都需要实现该接口</p>
 * 所谓向上关联，就是指这个角色关联的某个用户、某个组织机构、某个岗位等业务信息
 * @author yinwenjie
 */
public interface RoleUpRelationRegister {
  /**
   * 实现该接口的，或者说需要借助事件监听和RBAC模块进行依赖集成的业务模块的名字
   * @return 
   */
  public String moduleName();
  /**
   * 当RBAC模块根据自身的工作逻辑，需要依赖它的第三方业务模块返回按照指定的角色code，
   * 返回和这个rolecode绑定的或间接绑定的用户账户信息时，该方法会被触发
   * @param roleCode 
   * @param tenantCode 涉及的二级租户（例如经销商）信息
   * @return 
   */
  public List<String> onRequestUserAccount(String roleCode , String tenantCode);
} 