package com.bizunited.nebula.rbac.sdk.service;

import com.bizunited.nebula.rbac.sdk.vo.RoleVo;

/**
 * RBAC-SDK层角色信息相关操作。注意，这里只有写信息（创建、修改）相关的操作
 * @author yinwenjie
 */
public interface RoleVoService {
  /**
   * 进行角色信息的创建，一定注意其中的tenantCode信息。另外，id不能传入
   * @param roleVo 注意，其中的source、userAccountMaps、topCompetences、cacheInvalid 即使传入也不会起作用</br>
   * 但是有时候会直接指定角色关联的功能、按钮信息，则通过functionMaps进行传入
   * @return 
   */
  public RoleVo create(RoleVo roleVo);
  /**
   * 进行角色信息的修改
   * @param roleVo
   * @return
   */
  public RoleVo update(RoleVo roleVo);
  /**
   * 批量重新启用某一个指定的角色信息
   * @param roleIds
   * @return
   */
  public void enable(String[] roleIds);
  /**
   * 批量禁用某一个指定的角色信息（相当于删除）<br>
   * 只是系统中不能真正的删除某一个角色，只能是将这个角色作废掉或者恢复正常状态
   * @param roleIds
   * @return
   */
  public void disable(String[] roleIds);
  /**
   * 按照指定的角色业务编号进行角色删除（当然，仅限于当前操作者所在租户）
   * @param roleCodes
   */
  public void deleteByRoleCodes(String[] roleCodes);
  /**
   * 查询指定的角色信息，按照角色的数据层编号查询（不经过缓存，直接从数据库进行查询）
   * @param roleCode 角色编号
   * @return
   */
  public RoleVo findByTenantCodeAndRoleCode(String tenantCode , String roleCode);

  /**
   * 复制角色
   * @param vo
   */
  void copy(RoleVo vo);
}