package com.bizunited.nebula.rbac.sdk.service;

import java.util.Set;

import com.bizunited.nebula.rbac.sdk.vo.RoleVo;

/**
 * RBAC-SDK层角色信息相关操作（带缓存）服务。注意，这里只有查询服务
 * @author yinwenjie
 */
public interface RoleVoCacheService {
  /**
   * 缓存变化订阅的固定键值——通知tenantCode下的所有role都要缓存清理
   */
  public static final String TENANT_ROLE_NOTIFY = "_TENANT_ROLE_NOTIFY";
  /**
   * 缓存变化订阅的固定键值——通知tenantCode下指定的roleCode要进行缓存清理
   */
  public static final String TENANT_ROLE_IDENTITY_NOTIFY = "_TENANT_ROLE_IDENTITY_NOTIFY";
  /**
   * 当角色模块或其上层依赖模块有任何写操作发生时，需要调用该方法，通过redis全局广播的方式，通知当前资源桶下的所有工作节点
   * 指定租户下的营销活动发生了变化，以便所有工作节点能够清理缓存
   * @param tenantCode
   */
  public void notifyCacheRefresh(String tenantCode);
  /**
   * 和notifyCacheRefresh(String)方法不同的是，该缓存失效通知只针对指定tenantCode下的指定角色信息
   * @param tenantCode 
   * @param roleCode
   * @see #notifyCacheRefresh(String)
   */
  public void notifyCacheRefresh(String tenantCode , String roleCode);
  /**
   * 基于租户业务编号，清除角色缓存
   * @param tenantCode
   */
  public void clearCache(String tenantCode);
  /**
   * 基于租户业务编号，清除角色缓存
   * @param tenantCode 指定的租户（经销商）信息
   * @param roleCode 指定的角色业务编号信息
   */
  public void clearCache(String tenantCode, String roleCode);
  /**
   * 任何业务系统都会有一个基础角色。</br>
   * 这个默认基础角色的用途很大，例如可以在创建用户时，为新的用户绑定基本角色，从而让用户具备基本的功能权限</br>
   * 该方法就是可以向RBAC模块的上层业务模块，返回系统设定的基本角色业务编号
   * @return
   */
  public String findBaseRoleCode();
  /**
   * 查询指定的角色信息，按照角色的数据层编号查询
   * @param roleCode 角色编号
   * @return
   */
  public RoleVo findByTenantCodeAndRoleCode(String tenantCode , String roleCode);
  /**
   * 根据角色编码与租户编号查询角色信息
   * @param roleCodes
   * @return
   */
  public Set<RoleVo> findByTenantCodeAndRoleCodes(String tenantCode , Set<String> roleCodes);
  /**
   * 根据用户信息，查询指定用户所直接关联的或者间接关联的角色信息
   * @param tenantCode 
   * @param userAccount 
   * @return 
   */
  public Set<RoleVo> findByTenantCodeAndUserAccount(String tenantCode , String userAccount);
  /**
   * 查询角色树状关系
   * @return
   */
  public Set<RoleVo> findRoleTree(String tenantCode);
  /**
   * TODO 注释未写
   * @param tenantCode
   * @return
   */
  public Set<RoleVo> findRoleTree(String tenantCode , String roleCode);
}

