package com.bizunited.nebula.security.local.notifier;

import java.util.List;
import java.util.Set;

import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

import com.bizunited.nebula.security.sdk.event.AuthenticationRbacEventListener;
import com.google.common.collect.Sets;

/**
 * 为了简化那些无需控制当前访问功能的权限的应用系统，nebula-security组件提供了一个默认的AuthenticationRbacEventListener监听接口实现</br>
 * 其中包括了在任何需要控制访问方法的场景下，都返回"ADMIN"这个角色的默认实现
 * @author yinwenjie
 */
public class DefaultAuthenticationRbacEventListener implements AuthenticationRbacEventListener {

  @Override
  public Set<String> onRequestRoleCodes(List<RequestMappingInfo> matchedRequestMappings, String tenantCode, String currentMethod) {
    return Sets.newHashSet("ADMIN");
  }

  @Override
  public Set<String> onRequestIgnoreMethodCheckRoles() {
    // 默认获取“ADMIN”这个角色是管理员角色
    return Sets.newHashSet("ADMIN");
  }
}
