package com.bizunited.nebula.security.local.notifier;

import java.util.Set;

import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.google.common.collect.Sets;

/**
 * 为了简化那些无需控制用户角色信息的应用程序的集成过程，nebula-security组件提供了一个默认的AuthenticationUserEventListener监听实现</br>
 * 其中使用了默认的角色信息，作为所有当前操作者的角色信息
 * @author yinwenjie
 */
public class DefaultAuthenticationUserEventListener implements AuthenticationUserEventListener {

  @Override
  public Set<String> onRequestRoleCodes(String tenantCode, String account) {
    // 默认实现中，所有账户都具有ADMIN角色
    return Sets.newHashSet("ADMIN");
  }
}
