package com.bizunited.nebula.security.local.service.handle;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

/**
 * 重写了访问请求无权限时或者登录信息过期时的异常处理器，请注意，只有在鉴权并明确抛出AccessDeniedException异常时，该处理器才会生效
 * @author yinwenjie
 *
 */
public class SimpleAccessDeniedHandler implements AuthenticationEntryPoint , AccessDeniedHandler , InitializingBean , HandleOutPut {
  
  private static final String SESSION_USER_MISS = "用户已失效或未登录!";
  
  private static final String SESSION_DENIED = "用户无权访问该功能!";
  
  private SimpleSecurityProperties simpleSecurityProperties;

  public SimpleAccessDeniedHandler(SimpleSecurityProperties simpleSecurityProperties) {
    this.simpleSecurityProperties = simpleSecurityProperties;
  }
  
  @Override
  public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
    ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E601,new IllegalAccessException(SESSION_USER_MISS));
    String loginPageUrl = simpleSecurityProperties.getLoginPageUrl();
    String deniedRedirect = StringUtils.isBlank(loginPageUrl)?"":loginPageUrl;
    result.setData(deniedRedirect);
    this.writeResponse(response, result);
  }

  @Override
  public void afterPropertiesSet() throws Exception {
  }

  @Override
  public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
    ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E602,new IllegalAccessException(SESSION_DENIED));
    String loginPageUrl = simpleSecurityProperties.getLoginPageUrl();
    String deniedRedirect = StringUtils.isBlank(loginPageUrl)?"":loginPageUrl;
    result.setData(deniedRedirect);
    this.writeResponse(response, result);
  }
}
