/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.config;

import com.bizunited.nebula.common.filters.AppFilter;
import com.bizunited.nebula.common.filters.TenantFilter;
import com.bizunited.nebula.security.local.notifier.DefaultAuthenticationRbacEventListener;
import com.bizunited.nebula.security.local.notifier.DefaultAuthenticationUserEventListener;
import com.bizunited.nebula.security.local.service.CustomAccessDecisionManager;
import com.bizunited.nebula.security.local.service.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.nebula.security.local.service.CustomFilterSecurityInterceptor;
import com.bizunited.nebula.security.local.service.SimpleAuthenticationDetailsSource;
import com.bizunited.nebula.security.local.service.SimpleAuthenticationProvider;
import com.bizunited.nebula.security.local.service.handle.SimpleAccessDeniedHandler;
import com.bizunited.nebula.security.local.service.handle.SimpleAuthenticationFailureHandler;
import com.bizunited.nebula.security.local.service.handle.SimpleAuthenticationSuccessHandler;
import com.bizunited.nebula.security.sdk.config.NebulaWebSecurityConfigurerAdapter;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticationRbacEventListener;
import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.bizunited.nebula.security.sdk.password.Aes2PasswordEncoder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@ComponentScan(basePackages={"com.bizunited.nebula.security"})
public class SecurityConfigAutoConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfigAutoConfiguration.class);
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler authenticationFailureHandler;
    @Autowired
    private LogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    private AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> authenticationDetailsSource;
    @Autowired
    private AccessDecisionManager accessDecisionManager;
    @Autowired
    private SimpleAuthenticationProvider authenticationProvider;
    @Autowired
    private FilterInvocationSecurityMetadataSource securityMetadataSource;
    @Autowired(required=false)
    private NebulaWebSecurityConfigurerAdapter nebulaWebSecurityConfigurerAdapter;
    @Autowired
    private AppFilter appFilter;
    @Autowired
    private TenantFilter tenantFilter;

    protected void configure(HttpSecurity http) throws Exception {
        CustomFilterSecurityInterceptor filterSecurityInterceptor = new CustomFilterSecurityInterceptor(this.securityMetadataSource, this.accessDecisionManager, super.authenticationManager());
        CorsConfigurationSource configurationSource = this.corsConfigurationSource();
        SimpleAccessDeniedHandler simpleAccessDeniedHandler = new SimpleAccessDeniedHandler(this.simpleSecurityProperties);
        Object[] ignoreUrls = this.simpleSecurityProperties.getIgnoreUrls();
        String loginUrl = this.simpleSecurityProperties.getLoginUrl();
        String logoutUrl = this.simpleSecurityProperties.getLogoutUrl();
        String loginPageUrl = this.simpleSecurityProperties.getLoginPageUrl();
        String logoutSuccessRedirect = this.simpleSecurityProperties.getLogoutSuccessRedirect();
        ArrayList<String> currentIgnoreUrls = new ArrayList<String>();
        if (ignoreUrls != null && ignoreUrls.length > 0) {
            currentIgnoreUrls.addAll(Lists.newArrayList((Object[])ignoreUrls));
        }
        currentIgnoreUrls.addAll(Lists.newArrayList((Object[])SimpleSecurityProperties.DEFAULT_IGNOREURLS));
        if (StringUtils.isNotBlank((CharSequence)logoutSuccessRedirect)) {
            currentIgnoreUrls.add(logoutSuccessRedirect);
        }
        if (StringUtils.isNotBlank((CharSequence)loginPageUrl)) {
            currentIgnoreUrls.add(loginPageUrl);
        }
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.addFilterAt((Filter)filterSecurityInterceptor, FilterSecurityInterceptor.class).cors().configurationSource(configurationSource).and()).headers().frameOptions().disable().and()).sessionManagement().enableSessionUrlRewriting(true).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().antMatchers(currentIgnoreUrls.toArray(new String[0]))).permitAll().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)simpleAccessDeniedHandler).accessDeniedHandler((AccessDeniedHandler)simpleAccessDeniedHandler).and()).formLogin().loginPage("/v1/rbac/loginFail").loginProcessingUrl(loginUrl)).successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler)).authenticationDetailsSource(this.authenticationDetailsSource)).permitAll()).and()).logout().logoutUrl(logoutUrl).logoutSuccessHandler(this.logoutSuccessHandler).permitAll().and()).csrf().disable()).addFilterBefore((Filter)this.appFilter, UsernamePasswordAuthenticationFilter.class).addFilterAfter((Filter)this.tenantFilter, UsernamePasswordAuthenticationFilter.class);
        if (this.nebulaWebSecurityConfigurerAdapter != null) {
            this.nebulaWebSecurityConfigurerAdapter.configure(http);
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
    }

    @Bean(value={"simpleAuthenticationSuccessHandler"})
    @ConditionalOnMissingBean
    public AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        return new SimpleAuthenticationSuccessHandler();
    }

    @Bean(value={"simpleAuthenticationFailureHandler"})
    @ConditionalOnMissingBean
    public AuthenticationFailureHandler getAuthenticationFailureHandler() {
        return new SimpleAuthenticationFailureHandler();
    }

    @Bean(name={"passwordEncoder"})
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return new Pbkdf2PasswordEncoder();
    }

    @Bean(name={"aes2PasswordEncoder"})
    @ConditionalOnMissingBean
    public Aes2PasswordEncoder aes2PasswordEncoder() {
        return new Aes2PasswordEncoder();
    }

    @Bean(name={"customAccessDecisionManager"})
    @ConditionalOnMissingBean
    public AccessDecisionManager getCustomAccessDecisionManager() {
        return new CustomAccessDecisionManager();
    }

    @Bean(name={"customFilterInvocationSecurityMetadataSource"})
    @ConditionalOnMissingBean
    public FilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
        return new CustomFilterInvocationSecurityMetadataSource();
    }

    @Bean(name={"authenticationDetailsSource"})
    @ConditionalOnMissingBean
    public AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> getAuthenticationDetailsSource() {
        return new SimpleAuthenticationDetailsSource();
    }

    private CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("*"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationRbacEventListener getDefaultAuthenticationRbacEventListener() {
        LOGGER.warn(" ==== \u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684AuthenticationRbacEventListener\u76d1\u542c\u63a5\u53e3\u5b9e\u73b0com.bizunited.nebula.security.local.notifier.DefaultAuthenticationRbacEventListener\uff0c\u8be5\u5b9e\u73b0\u9ed8\u8ba4\u6240\u6709\u7684\u65b9\u6cd5\u90fd\u53ef\u4ee5\u8bbf\u95ee\uff0c\u5982\u679c\u9700\u8981\u9650\u5236\u65b9\u6cd5\u6743\u9650\uff0c\u8bf7\u81ea\u884c\u5b9e\u73b0AuthenticationRbacEventListener\u76d1\u542c\u63a5\u53e3\uff08\u82e5\u5df2\u4f7f\u7528@Primary\u6ce8\u89e3\uff0c\u5219\u53ef\u4ee5\u5ffd\u7565\u8be5\u8b66\u544a\uff09!! ");
        return new DefaultAuthenticationRbacEventListener();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationUserEventListener getDefaultAuthenticationUserEventListener() {
        LOGGER.warn(" ==== \u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684AuthenticationUserEventListener\u76d1\u542c\u63a5\u53e3\u5b9e\u73b0com.bizunited.nebula.security.local.notifier.DefaultAuthenticationUserEventListener\uff0c\u8be5\u5b9e\u73b0\u9ed8\u8ba4\u6240\u6709\u7684\u64cd\u4f5c\u8005\u90fd\u62e5\u6709ADMIN\u89d2\u8272\uff0c\u5982\u9700\u8981\u9650\u5236\u7528\u6237\u7684\u89d2\u8272\uff0c\u8bf7\u81ea\u884c\u5b9e\u73b0AuthenticationUserEventListener\u76d1\u542c\u63a5\u53e3(\u82e5\u5df2\u4f7f\u7528@Primary\u6ce8\u89e3\uff0c\u5219\u53ef\u4ee5\u5ffd\u7565\u8be5\u8b66\u544a)!! ");
        return new DefaultAuthenticationUserEventListener();
    }
}

