/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.notifier;

import com.bizunited.nebula.common.event.RequestTenantInfoEventListener;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.bizunited.nebula.security.sdk.vo.SimpleTenantInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.util.CollectionUtils;

public class TenantRequestEventListenerForSecurity
implements RequestTenantInfoEventListener {
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    public AbstractTenantInfo onBuildTenantInfo(HttpServletRequest request, HttpServletResponse response) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return null;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return null;
        }
        LoginDetails loginDetails = (LoginDetails)authentication.getDetails();
        if (loginDetails == null) {
            return null;
        }
        TenantContextHolder.setTenant((String)loginDetails.getTenantCode());
        SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo();
        return simpleTenantInfo;
    }

    public boolean shouldNotTenantInfoFilter(HttpServletRequest request) {
        Object[] ignoreUrls = this.simpleSecurityProperties.getIgnoreUrls();
        Object[] ignoreUrlsButFilterTenantCode = this.simpleSecurityProperties.getIgnoreUrlsButFilterTenantCode();
        if (ArrayUtils.isEmpty((Object[])ignoreUrls)) {
            return false;
        }
        ArrayList<AntPathRequestMatcher> ignoreUrlmatchers = new ArrayList<AntPathRequestMatcher>();
        ArrayList<AntPathRequestMatcher> ignoreUrlsButFilterTenantCodeMatchers = new ArrayList<AntPathRequestMatcher>();
        for (Object pattern : ignoreUrls) {
            ignoreUrlmatchers.add(new AntPathRequestMatcher((String)pattern, null));
        }
        if (!ArrayUtils.isEmpty((Object[])ignoreUrlsButFilterTenantCode)) {
            for (Object pattern : ignoreUrlsButFilterTenantCode) {
                ignoreUrlsButFilterTenantCodeMatchers.add(new AntPathRequestMatcher((String)pattern, null));
            }
        }
        OrRequestMatcher matcher = new OrRequestMatcher(ignoreUrlmatchers);
        OrRequestMatcher butFilterTenantCodeMatcher = null;
        if (!CollectionUtils.isEmpty(ignoreUrlsButFilterTenantCodeMatchers)) {
            butFilterTenantCodeMatcher = new OrRequestMatcher(ignoreUrlsButFilterTenantCodeMatchers);
        }
        if (matcher.matches(request) && butFilterTenantCodeMatcher != null) {
            return butFilterTenantCodeMatcher.matches(request);
        }
        return false;
    }

    public boolean shouldNotAppFilter(HttpServletRequest request) {
        Object[] ignoreUrls = this.simpleSecurityProperties.getIgnoreUrls();
        Object[] ignoreUrlsButFilterAppCode = this.simpleSecurityProperties.getIgnoreUrlsButFilterAppCode();
        if (ArrayUtils.isEmpty((Object[])ignoreUrls)) {
            return false;
        }
        ArrayList<AntPathRequestMatcher> ignoreUrlmatchers = new ArrayList<AntPathRequestMatcher>();
        ArrayList<AntPathRequestMatcher> ignoreUrlsButFilterAppCodeMatchers = new ArrayList<AntPathRequestMatcher>();
        for (Object pattern : ignoreUrls) {
            ignoreUrlmatchers.add(new AntPathRequestMatcher((String)pattern, null));
        }
        if (!ArrayUtils.isEmpty((Object[])ignoreUrlsButFilterAppCode)) {
            for (Object pattern : ignoreUrlsButFilterAppCode) {
                ignoreUrlsButFilterAppCodeMatchers.add(new AntPathRequestMatcher((String)pattern, null));
            }
        }
        OrRequestMatcher matcher = new OrRequestMatcher(ignoreUrlmatchers);
        OrRequestMatcher butFilterAppCodeMatcher = null;
        if (!CollectionUtils.isEmpty(ignoreUrlsButFilterAppCodeMatchers)) {
            butFilterAppCodeMatcher = new OrRequestMatcher(ignoreUrlsButFilterAppCodeMatchers);
        }
        if (matcher.matches(request) && butFilterAppCodeMatcher != null) {
            return butFilterAppCodeMatcher.matches(request);
        }
        return false;
    }
}

