/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.service;

import com.bizunited.nebula.security.sdk.event.AuthenticationRbacEventListener;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.CollectionUtils;

public class CustomAccessDecisionManager
implements AccessDecisionManager {
    @Autowired(required=false)
    private AuthenticationRbacEventListener authenticationRbacEventListener;

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        Set ignoreMethodCheckRoleCodes;
        if (configAttributes == null || configAttributes.isEmpty()) {
            throw new AccessDeniedException("not author!");
        }
        for (ConfigAttribute configAttribute : configAttributes) {
            String roleName = configAttribute.getAttribute();
            if (!StringUtils.equals((CharSequence)roleName, (CharSequence)"ANONYMOUS")) continue;
            return;
        }
        Collection currentAuthors = authentication.getAuthorities();
        if (currentAuthors == null || currentAuthors.isEmpty()) {
            throw new AccessDeniedException("not found any author from this single in user!");
        }
        if (this.authenticationRbacEventListener != null && !CollectionUtils.isEmpty((Collection)(ignoreMethodCheckRoleCodes = this.authenticationRbacEventListener.onRequestIgnoreMethodCheckRoles()))) {
            for (GrantedAuthority grantedAuthority : currentAuthors) {
                for (String ignoreMethodCheckRoleCode : ignoreMethodCheckRoleCodes) {
                    if (!StringUtils.equals((CharSequence)grantedAuthority.getAuthority(), (CharSequence)ignoreMethodCheckRoleCode)) continue;
                    return;
                }
            }
        }
        for (ConfigAttribute securityConfig : configAttributes) {
            for (GrantedAuthority grantedAuthority : currentAuthors) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)securityConfig.getAttribute(), (CharSequence)grantedAuthority.getAuthority())) continue;
                return;
            }
        }
        throw new AccessDeniedException("not author!");
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

