/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.service;

import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticationRbacEventListener;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CustomFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static final SecurityConfig ANONYMOUS_CONFIG = new SecurityConfig("ANONYMOUS");
    @Autowired
    private SimpleSecurityProperties securityProperties;
    @Autowired
    private RequestMappingHandlerMapping frameworkEndpointHandler;
    @Autowired(required=false)
    private AuthenticationRbacEventListener authenticationRbacEventListener;

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        Object loginDetailsObject;
        FilterInvocation filterInvocation = (FilterInvocation)object;
        HttpServletRequest httpRequest = filterInvocation.getHttpRequest();
        ArrayList<ConfigAttribute> configs = new ArrayList<ConfigAttribute>();
        ArrayList currentIgnoreUrls = new ArrayList();
        Object[] ignoreUrls = this.securityProperties.getIgnoreUrls();
        if (ignoreUrls != null && ignoreUrls.length > 0) {
            currentIgnoreUrls.addAll(Lists.newArrayList((Object[])ignoreUrls));
        }
        currentIgnoreUrls.addAll(Lists.newArrayList((Object[])SimpleSecurityProperties.DEFAULT_IGNOREURLS));
        for (String ignoreUrl : currentIgnoreUrls) {
            AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(ignoreUrl);
            if (!requestMatcher.matches(httpRequest)) continue;
            configs.add((ConfigAttribute)ANONYMOUS_CONFIG);
            return configs;
        }
        if (this.authenticationRbacEventListener == null) {
            throw new AccessDeniedException("not author\uff08no authenticationRbacEventListener\uff09!");
        }
        Set ignoreMethodCheckRoleCodes = this.authenticationRbacEventListener.onRequestIgnoreMethodCheckRoles();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new AccessDeniedException("not author\uff08no authentication\uff09!");
        }
        Collection currentRoles = authentication.getAuthorities();
        Set currentRoleCodes = currentRoles.stream().map(Object::toString).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty((Collection)ignoreMethodCheckRoleCodes) && !CollectionUtils.isEmpty((Collection)currentRoles)) {
            CharSequence[] ignoreMethodCheckArrayRoleCodes = ignoreMethodCheckRoleCodes.toArray(new String[0]);
            for (String currentRoleCode : currentRoleCodes) {
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)currentRoleCode, (CharSequence[])ignoreMethodCheckArrayRoleCodes)) continue;
                SecurityConfig securityConfig = new SecurityConfig(currentRoleCode);
                configs.add((ConfigAttribute)securityConfig);
                return configs;
            }
        }
        if (!((loginDetailsObject = authentication.getDetails()) instanceof LoginDetails)) {
            throw new AccessDeniedException("not author\uff08no login\uff09!");
        }
        LoginDetails loginDetails = (LoginDetails)loginDetailsObject;
        String tenantCode = loginDetails.getTenantCode();
        Map pathMapping = this.frameworkEndpointHandler.getHandlerMethods();
        Set requestMappings = pathMapping.keySet();
        ArrayList matchingResults = Lists.newArrayList();
        String currentMethod = httpRequest.getMethod();
        for (RequestMappingInfo requestMappingInfo : requestMappings) {
            RequestMappingInfo current = requestMappingInfo.getMatchingCondition(httpRequest);
            if (current == null) continue;
            matchingResults.add(current);
        }
        if (matchingResults.isEmpty()) {
            configs.add((ConfigAttribute)ANONYMOUS_CONFIG);
            return configs;
        }
        Set currentCompetenceCodes = this.authenticationRbacEventListener.onRequestRoleCodes((List)matchingResults, tenantCode, currentMethod);
        if (CollectionUtils.isEmpty((Collection)currentCompetenceCodes)) {
            throw new AccessDeniedException("not author( no competence mapping role)!");
        }
        for (String currentCompetenceCode : currentCompetenceCodes) {
            SecurityConfig securityConfig = new SecurityConfig(currentCompetenceCode);
            configs.add((ConfigAttribute)securityConfig);
        }
        return configs;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return Collections.emptyList();
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

