/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.service;

import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SimpleAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleAuthenticationProvider.class);
    private static final String ERROR_TYPE = "\u76ee\u524d\u7528\u6237\u9274\u6743\u6a21\u5f0f\u652f\u63016\u4e2d\u65b9\u5f0f\uff1a1\u3001\u5178\u578b\u7684\u8d26\u6237\u540d+\u5bc6\u7801\u65b9\u5f0f\uff1b2\u3001\u5178\u578b\u7684\u8d26\u6237\u540d + \u5bc6\u7801 + \u6821\u9a8c\u7801\u65b9\u5f0f\uff1b3\u3001\u7528\u6237\u540d + \u77ed\u4fe1\u9a8c\u8bc1\u7801 + \u6821\u9a8c\u7801\u65b9\u5f0f\uff1b 4\u3001\u624b\u673a\u53f7 + \u5bc6\u7801\u65b9\u5f0f\uff1b5\u3001\u624b\u673a\u53f7 + \u77ed\u4fe1\u9a8c\u8bc1\u7801\uff1b6\u3001\u624b\u673a\u53f7 + \u77ed\u4fe1\u9a8c\u8bc1\u7801 + \u6821\u9a8c\u7801\u65b9\u5f0f\uff1b7\u3001\u4e1a\u52a1\u7cfb\u7edf\u81ea\u5b9a\u7684\u5176\u5b83\u767b\u5f55\u65b9\u5f0f";
    private static final String ERROR_USER = "\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\u6216\u5176\u6570\u636e\u5b58\u50a8\u7f16\u53f7\uff0c\u4e5f\u53ef\u80fd\u662f\u56e0\u4e3a\u6307\u5b9a\u7684\u9274\u6743\u65b9\u5f0f\u6682\u672a\u5b9e\u73b0";
    private static final String ERROR_ROLE = "\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u5e26\u6709\u4efb\u4f55\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u6743\u9650\u8bbe\u5b9a";
    @Autowired(required=false)
    private List<AuthenticationDecisionStrategy> authenticationDecisions;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired
    private AuthenticationUserEventListener authenticationEventListener;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (CollectionUtils.isEmpty(this.authenticationDecisions)) {
            throw new AuthenticationCredentialsNotFoundException("\u672c\u5e94\u7528\u7cfb\u7edf/\u5fae\u670d\u52a1\uff0c\u7981\u6b62\u4efb\u4f55\u5f62\u5f0f\u7684\u767b\u5f55(\u6ca1\u6709\u4efb\u4f55\u767b\u5f55\u7b56\u7565)!!");
        }
        LoginDetails loginDetails = (LoginDetails)authentication.getDetails();
        LOGGER.debug("\u5f53\u524d\u6709\u7528\u6237\u6b63\u5728\u8fdb\u884c\u7ecf\u5178\u767b\u5f55\u9274\u6743 =  " + loginDetails.toString());
        Integer type = loginDetails.getType();
        if (type == null) {
            type = this.simpleSecurityProperties.getDefaultLoginType();
        }
        Validate.isTrue((type > 0 && type <= 7 ? 1 : 0) != 0, (String)ERROR_TYPE, (Object[])new Object[0]);
        boolean success = false;
        try {
            for (AuthenticationDecisionStrategy authenticationDecisionStrategy : this.authenticationDecisions) {
                Integer currentCode = authenticationDecisionStrategy.type().getCode();
                if (!currentCode.equals(type)) continue;
                success = authenticationDecisionStrategy.onAuthenticate(loginDetails);
                break;
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new AuthenticationCredentialsNotFoundException(e.getMessage(), (Throwable)e);
        }
        if (!success || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{loginDetails.getTenantCode(), loginDetails.getAccount(), loginDetails.getPassword()})) {
            throw new UsernameNotFoundException(ERROR_USER);
        }
        if (this.authenticationEventListener != null) {
            Set roleCodes = this.authenticationEventListener.onRequestRoleCodes(loginDetails.getTenantCode(), loginDetails.getAccount());
            if (CollectionUtils.isEmpty((Collection)roleCodes)) {
                throw new BadCredentialsException(ERROR_ROLE);
            }
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            for (String roleCode : roleCodes) {
                SimpleGrantedAuthority authoritie = new SimpleGrantedAuthority(StringUtils.upperCase((String)roleCode));
                authorities.add(authoritie);
            }
            return new UsernamePasswordAuthenticationToken((Object)loginDetails.getAccount(), (Object)loginDetails.getPassword(), authorities);
        }
        throw new BadCredentialsException("\u672a\u914d\u7f6enebula-security\u7ec4\u4ef6\u7684\u5b9e\u73b0\u6a21\u5757\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!!");
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }
}

