/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.service.handle;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.security.local.service.handle.HandleOutPut;
import com.bizunited.nebula.security.sdk.event.AuthenticatedEventListener;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.util.CollectionUtils;

public class SimpleAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler
implements HandleOutPut {
    @Autowired(required=false)
    private AuthenticatedEventListener authenticatedEventListener;

    @Transactional
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LoginDetails loginDetails = (LoginDetails)authentication.getDetails();
        String tenantCode = loginDetails.getTenantCode();
        TenantContextHolder.setTenant((String)tenantCode);
        if (this.authenticatedEventListener != null) {
            this.authenticatedEventListener.onAuthenticationSuccess(loginDetails, authentication);
        }
        Collection setCookies = response.getHeaders("Set-Cookie");
        String jsession = null;
        if (setCookies != null) {
            for (String setCookie : setCookies) {
                String value;
                int indexd;
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"persistence=") != -1) {
                    indexd = setCookie.indexOf(61);
                    value = setCookie.substring(indexd + 1);
                    response.setHeader("persistence", value);
                    continue;
                }
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"JSESSIONID=") == -1) continue;
                indexd = setCookie.indexOf(61);
                jsession = value = setCookie.substring(indexd + 1);
            }
            response.setHeader("Access-Control-Expose-Headers", "JSESSIONID,persistence,Cookie");
        }
        if (StringUtils.isBlank(jsession)) {
            HttpSession session = request.getSession();
            jsession = session.getId();
            Cookie cookie = new Cookie("JSESSIONID", jsession);
            cookie.setSecure(true);
            response.addCookie(cookie);
            session.setAttribute("tenantCode", (Object)tenantCode);
        }
        response.setHeader("JSESSIONID", jsession);
        ResponseModel result = new ResponseModel(Long.valueOf(System.currentTimeMillis()), null, ResponseCode.E0, null);
        JSONObject resultJson = new JSONObject();
        String[] roles = null;
        Collection authoritys = authentication.getAuthorities();
        if (!CollectionUtils.isEmpty((Collection)authoritys)) {
            roles = (String[])authoritys.stream().map(GrantedAuthority::getAuthority).toArray(String[]::new);
        }
        resultJson.put("account", (Object)loginDetails.getAccount());
        resultJson.put("phone", (Object)loginDetails.getPhone());
        resultJson.put("tenantCode", (Object)loginDetails.getTenantCode());
        resultJson.put("username", (Object)loginDetails.getUsername());
        resultJson.put("roles", (Object)roles);
        result.setData((Object)resultJson);
        this.writeResponse(response, result);
    }
}

