/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.login;

import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.security.local.loginform.NebulaSecurityLoginFormDetailsSource;
import com.bizunited.nebula.security.local.utils.HandleOutPut;
import com.bizunited.nebula.security.sdk.event.AuthenticatedEventListener;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.util.CollectionUtils;

public class NebulaSecurityAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler
implements HandleOutPut {
    @Autowired(required=false)
    private List<AuthenticatedEventListener> authenticatedEventListeners;
    @Autowired
    private NebulaSecurityLoginFormDetailsSource nebulaSecurityLoginFormDetailsSource;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        LoginDetails loginDetails = this.nebulaSecurityLoginFormDetailsSource.buildDetails(request);
        if (!CollectionUtils.isEmpty(this.authenticatedEventListeners)) {
            for (AuthenticatedEventListener authenticatedEventListener : this.authenticatedEventListeners) {
                authenticatedEventListener.onAuthenticationFailed(loginDetails, exception);
            }
        }
        ResponseModel result = new ResponseModel(Long.valueOf(new Date().getTime()), null, ResponseCode.E501, (Throwable)exception);
        this.writeResponse(response, result);
    }
}

