/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.login;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.security.local.utils.HandleOutPut;
import com.bizunited.nebula.security.sdk.event.NebulaSecurityAuthenticationSuccessPrinter;
import com.bizunited.nebula.security.sdk.event.SuccessPrinterContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.util.CollectionUtils;

public class NebulaSecurityAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler
implements HandleOutPut {
    @Autowired(required=false)
    private List<NebulaSecurityAuthenticationSuccessPrinter> nebulaSecurityAuthenticationSuccessPrinters;
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaSecurityAuthenticationSuccessHandler.class);

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SuccessPrinterContext successPrinterContext = new SuccessPrinterContext();
        if (!CollectionUtils.isEmpty(this.nebulaSecurityAuthenticationSuccessPrinters)) {
            for (NebulaSecurityAuthenticationSuccessPrinter nebulaSecurityAuthenticationSuccessPrinter : this.nebulaSecurityAuthenticationSuccessPrinters) {
                nebulaSecurityAuthenticationSuccessPrinter.print(successPrinterContext, request, response, authentication);
            }
        }
        ResponseModel result = new ResponseModel(Long.valueOf(System.currentTimeMillis()), null, ResponseCode.E0, null);
        JSONObject resultJson = new JSONObject();
        Set entrys = successPrinterContext.entrySet();
        for (Map.Entry entryItem : entrys) {
            resultJson.put((String)entryItem.getKey(), entryItem.getValue());
        }
        try {
            result.setData((Object)resultJson);
            this.writeResponse(response, result);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

