/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.notifier;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.configuration.SimpleTenantProperties;
import com.bizunited.nebula.common.event.RequestTenantInfoEventListener;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantRequestEventListenerForSecurity
implements RequestTenantInfoEventListener {
    @Autowired
    private SimpleTenantProperties simpleTenantProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantRequestEventListenerForSecurity.class);

    public AbstractTenantInfo onBuildTenantInfo() {
        Object authenticationObject;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        boolean hasAuthentication = false;
        Authentication authentication = null;
        UserIdentity userIdentity = null;
        if (securityContext != null && (authentication = securityContext.getAuthentication()) != null && (authenticationObject = authentication.getDetails()) != null && authenticationObject instanceof UserIdentity) {
            hasAuthentication = true;
            userIdentity = (UserIdentity)authenticationObject;
        }
        if (hasAuthentication) {
            String tenantCode = userIdentity.getTenantCode();
            if (StringUtils.isBlank((CharSequence)tenantCode)) {
                return this.buildOnServletRequest();
            }
            SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo(tenantCode);
            return simpleTenantInfo;
        }
        return this.buildOnServletRequest();
    }

    private String decodeBase64(String data) {
        return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
    }

    private AbstractTenantInfo buildOnServletRequest() {
        ServletRequestAttributes requestAttributes = null;
        try {
            requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        }
        catch (RuntimeException e) {
            LOGGER.warn("===== \u8fd9\u53ef\u80fd\u662f\u4e00\u4e2a\u65b0\u7684\u975eweb\u8bf7\u6c42\u7ebf\u7a0b\uff0c\u64cd\u4f5c\u8005\u8bd5\u56fe\u5728\u8fd9\u4e2a\u7ebf\u7a0b\u901a\u8fc7request\u8bf7\u6c42\u4e0a\u4e0b\u6587\u53d6\u5f97\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u9996\u5148\u4e3a\u8fd9\u79cd\u7ebf\u7a0b\u521b\u5efa\u7528\u6237\u8eab\u4efd\u4e0a\u4e0b\u6587\uff0c\u4ee5\u907f\u514d\u8be5\u8b66\u544a\u4fe1\u606f\u3002");
            return null;
        }
        if (requestAttributes == null) {
            if (this.simpleTenantProperties.getUseDefaultTenantCode().booleanValue()) {
                return new SimpleTenantInfo(this.simpleTenantProperties.getDefaultTenantCode());
            }
            return null;
        }
        ServletRequestAttributes servletRequestAttributes = requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();
        try {
            String securityData = request.getHeader(this.simpleTenantProperties.getHeadAppKey());
            if (StringUtils.isBlank((CharSequence)securityData)) {
                if (this.simpleTenantProperties.getUseDefaultTenantCode().booleanValue()) {
                    return new SimpleTenantInfo(this.simpleTenantProperties.getDefaultTenantCode());
                }
                return null;
            }
            String securityDataDecoded = this.decodeBase64(securityData);
            String tenantCode = null;
            if (this.isJSONType(securityDataDecoded)) {
                JSONObject jsonData = JSON.parseObject((String)securityDataDecoded);
                Validate.notNull((Object)jsonData, (String)"\u7f51\u5173\u4fe1\u606f\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                tenantCode = jsonData.getString("tenantCode");
                Validate.notBlank((CharSequence)tenantCode, (String)"\u7f51\u5173\u4fe1\u606f\u4e0d\u5168\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                LOGGER.debug("\u5f53\u524d\u8bf7\u6c42\u643a\u5e26\u7684\u79df\u6237\u4fe1\u606f\u4e3a:{}", (Object)tenantCode);
            } else {
                tenantCode = securityDataDecoded;
                Validate.notBlank((CharSequence)tenantCode, (String)"\u7f51\u5173\u4fe1\u606f\u4e0d\u5168\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                LOGGER.debug("\u5f53\u524d\u8bf7\u6c42\u643a\u5e26\u7684\u79df\u6237\u4fe1\u606f\u4e3a:{}", (Object)tenantCode);
            }
            SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo(tenantCode);
            return simpleTenantInfo;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (this.simpleTenantProperties.getUseDefaultTenantCode().booleanValue()) {
                return new SimpleTenantInfo(this.simpleTenantProperties.getDefaultTenantCode());
            }
            return null;
        }
    }

    private boolean isJSONType(String str) {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }
}

