/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.password;

import com.bizunited.nebula.security.sdk.config.PasswordValidateProperties;
import com.bizunited.nebula.security.sdk.password.PasswordValidateService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PasswordValidateServiceImpl
implements PasswordValidateService {
    @Autowired
    private PasswordValidateProperties passwordValidateProperties;

    public void validate(String password) {
        Validate.notBlank((CharSequence)password, (String)"\u5bc6\u7801\u4fe1\u606f\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String tiles = this.passwordValidateProperties.getTips();
        if (StringUtils.isBlank((CharSequence)tiles)) {
            tiles = "password validate illegality";
        }
        int passwordMinLength = this.passwordValidateProperties.getPasswordMinLength();
        int passwordMinSpecialChartLength = this.passwordValidateProperties.getPasswordMinSpecialChartLength();
        int passwordMinNumericLength = this.passwordValidateProperties.getPasswordMinNumericLength();
        int passwordMinChartLength = this.passwordValidateProperties.getPasswordMinChartLength();
        String passwordStrength = this.passwordValidateProperties.getPasswordStrength();
        PasswordValidateServiceImpl.validate(password, tiles, passwordMinLength, passwordMinSpecialChartLength, passwordMinNumericLength, passwordMinChartLength, passwordStrength);
    }

    private static void validate(String password, String tiles, int passwordMinLength, int passwordMinSpecialChartLength, int passwordMinNumericLength, int passwordMinChartLength, String passwordStrength) {
        int count;
        Matcher matcher;
        Pattern pattern;
        if (passwordMinLength > 0) {
            Validate.isTrue((password.length() >= passwordMinLength ? 1 : 0) != 0, (String)tiles, (Object[])new Object[0]);
        }
        if (passwordMinSpecialChartLength > 0) {
            pattern = Pattern.compile("[^A-Za-z0-9]");
            matcher = pattern.matcher(password);
            count = 0;
            while (matcher.find()) {
                ++count;
            }
            Validate.isTrue((count >= passwordMinSpecialChartLength ? 1 : 0) != 0, (String)tiles, (Object[])new Object[0]);
        }
        if (passwordMinNumericLength > 0) {
            pattern = Pattern.compile("[0-9]");
            matcher = pattern.matcher(password);
            count = 0;
            while (matcher.find()) {
                ++count;
            }
            Validate.isTrue((count >= passwordMinNumericLength ? 1 : 0) != 0, (String)tiles, (Object[])new Object[0]);
        }
        if (passwordMinChartLength > 0) {
            pattern = Pattern.compile("[A-Za-z]");
            matcher = pattern.matcher(password);
            count = 0;
            while (matcher.find()) {
                ++count;
            }
            Validate.isTrue((count >= passwordMinChartLength ? 1 : 0) != 0, (String)tiles, (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)passwordStrength)) {
            pattern = Pattern.compile(passwordStrength);
            matcher = pattern.matcher(password);
            Validate.isTrue((boolean)matcher.find(), (String)tiles, (Object[])new Object[0]);
        }
    }
}

