/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.service.internal;

import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.AuthenticationJwtTokenService;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationJwtTokenServiceImpl
implements AuthenticationJwtTokenService {
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationJwtTokenServiceImpl.class);

    public String rebuildJwt() {
        try {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Authentication authentication = securityContext.getAuthentication();
            Object authenticationObject = authentication.getDetails();
            Validate.isTrue((boolean)(authenticationObject instanceof UserIdentity), (String)"no User Identity", (Object[])new Object[0]);
            String jwtEncodeContent = JwtUtils.encode((UserIdentity)authenticationObject, this.simpleSecurityProperties.getJwtttl(), this.simpleSecurityProperties.getSecretKey());
            return jwtEncodeContent;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

