/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.transform;

import com.bizunited.nebula.security.local.utils.JWTContext;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.constant.Constants;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtRefreshAuthorizationFilter
extends OncePerRequestFilter {
    private static final String JWT_HEADER = "jwt";
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtRefreshAuthorizationFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String jwtText = request.getHeader(JWT_HEADER);
        if (StringUtils.isBlank((CharSequence)jwtText)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        response.setHeader(JWT_HEADER, jwtText);
        try {
            JWTContext jwtContent = JwtUtils.decode(jwtText, this.simpleSecurityProperties.getSecretKey());
            if (Objects.isNull(jwtContent.getExpiration())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            long remainValidTime = jwtContent.getExpiration().getTime() - System.currentTimeMillis();
            if (remainValidTime < 0L) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            int jwtRefreshTime = this.simpleSecurityProperties.getJwtRefreshTime();
            int n = jwtRefreshTime = jwtRefreshTime < 0 ? Constants.DEFAULT_JWT_REFRESH_TIME : jwtRefreshTime;
            if (remainValidTime <= (long)jwtRefreshTime) {
                int ttl = Objects.nonNull(jwtContent.getTtl()) ? jwtContent.getTtl().intValue() : this.simpleSecurityProperties.getJwtttl();
                String rebuildJwt = JwtUtils.encode(jwtContent, ttl, this.simpleSecurityProperties.getSecretKey());
                response.setHeader(JWT_HEADER, rebuildJwt);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5237\u65b0jwt\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

