/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.transform;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.security.local.utils.JWTContext;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.transform.IdentityTransformStrategy;
import com.bizunited.nebula.security.sdk.transform.IdentityTransformValidate;
import com.google.common.collect.Lists;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtSecurityAuthorizationFilter
extends OncePerRequestFilter {
    @Autowired(required=false)
    @Lazy
    private List<IdentityTransformStrategy> identityTransformStrategies;
    @Autowired(required=false)
    @Lazy
    private List<IdentityTransformValidate> identityTransformValidates;
    private static final String JWT_HEADER = "jwt";
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtSecurityAuthorizationFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String jwtText = request.getHeader(JWT_HEADER);
        if (StringUtils.isBlank((CharSequence)jwtText)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!this.simpleSecurityProperties.getIgnoreUrlsButJwt().booleanValue()) {
            ArrayList currentIgnoreUrls = new ArrayList();
            Object[] ignoreUrls = this.simpleSecurityProperties.getIgnoreUrls();
            if (ignoreUrls != null && ignoreUrls.length > 0) {
                currentIgnoreUrls.addAll(Lists.newArrayList((Object[])ignoreUrls));
            }
            currentIgnoreUrls.addAll(Lists.newArrayList((Object[])SimpleSecurityProperties.DEFAULT_IGNOREURLS));
            for (String ignoreUrl : currentIgnoreUrls) {
                AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(ignoreUrl);
                if (!requestMatcher.matches(request)) continue;
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        JWTContext jwtContent = null;
        try {
            jwtContent = JwtUtils.decode(jwtText, this.simpleSecurityProperties.getSecretKey());
            Validate.notNull((Object)jwtContent, (String)"jwt\u89e3\u6790\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u683c\u5f0f\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u7528\u6237\u8eab\u4efd\u4fe1\u606f\u5df2\u8fc7\u671f", (Object[])new Object[0]);
        }
        catch (ExpiredJwtException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.reset();
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/html;charset=UTF-8");
            response.setStatus(601);
            return;
        }
        catch (RuntimeException e) {
            Boolean hasAuthentication = this.tryAuthentication(response);
            if (hasAuthentication == null) {
                return;
            }
            if (!hasAuthentication.booleanValue()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                response.reset();
                response.setCharacterEncoding("utf-8");
                response.setContentType("text/html;charset=UTF-8");
                response.setStatus(601);
                LOGGER.error("jwt info = " + jwtText);
                return;
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String account = jwtContent.getAccount();
        String identityType = jwtContent.getIdentityType();
        String tenantCode = jwtContent.getTenantCode();
        JSONObject userInfo = jwtContent.getUserInfo();
        UserIdentity userIdentity = null;
        for (IdentityTransformStrategy identityTransformStrategy : this.identityTransformStrategies) {
            if (!identityTransformStrategy.matched(jwtContent.getIdentityType())) continue;
            userIdentity = identityTransformStrategy.transform(identityType, tenantCode, account, userInfo);
            break;
        }
        if (userIdentity == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String[] roleCodes = userIdentity.getRoleCodes();
        ArrayList authorities = Lists.newArrayList();
        if (roleCodes != null && roleCodes.length > 0) {
            for (String roleCode : roleCodes) {
                SimpleGrantedAuthority simpleGrantedAuthority = new SimpleGrantedAuthority(roleCode);
                authorities.add(simpleGrantedAuthority);
            }
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)userIdentity.getAccount(), (Object)"123456", (Collection)authorities);
        authenticationToken.setDetails((Object)userIdentity);
        securityContext.setAuthentication((Authentication)authenticationToken);
        try {
            if (!CollectionUtils.isEmpty(this.identityTransformValidates)) {
                for (IdentityTransformValidate identityTransformValidate : this.identityTransformValidates) {
                    if (!identityTransformValidate.matched(userIdentity)) continue;
                    identityTransformValidate.validate(userIdentity);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.reset();
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/html;charset=UTF-8");
            response.setStatus(601);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private Boolean tryAuthentication(HttpServletResponse response) {
        boolean hasAuthentication;
        block5: {
            Object authenticationDetail;
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Authentication currentAuthentication = securityContext.getAuthentication();
            hasAuthentication = false;
            if (currentAuthentication != null && (authenticationDetail = currentAuthentication.getDetails()) != null && authenticationDetail instanceof UserIdentity) {
                try {
                    if (!CollectionUtils.isEmpty(this.identityTransformValidates)) {
                        for (IdentityTransformValidate identityTransformValidate : this.identityTransformValidates) {
                            if (!identityTransformValidate.matched((UserIdentity)authenticationDetail)) continue;
                            identityTransformValidate.validate((UserIdentity)authenticationDetail);
                            hasAuthentication = true;
                            break block5;
                        }
                        break block5;
                    }
                    hasAuthentication = true;
                }
                catch (RuntimeException et) {
                    LOGGER.error(et.getMessage(), (Throwable)et);
                    response.reset();
                    response.setCharacterEncoding("utf-8");
                    response.setContentType("text/html;charset=UTF-8");
                    response.setStatus(601);
                    return null;
                }
            }
        }
        return hasAuthentication;
    }
}

