/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.utils;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.security.local.utils.JWTContext;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.Base64Utils;

public class JwtUtils {
    private JwtUtils() {
    }

    public static String encode(UserIdentity userIdentity, int ttl, String secretKey) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS512;
        Date now = new Date();
        HashMap jwsHeader = Maps.newHashMap();
        jwsHeader.put("alg", signatureAlgorithm.getValue());
        jwsHeader.put("kid", userIdentity.getAccount());
        jwsHeader.put("typ", userIdentity.getIdentityType());
        jwsHeader.put("ttl", ttl);
        jwsHeader.put("tenantCode", userIdentity.getTenantCode());
        JSONObject userJson = (JSONObject)JSONObject.toJSON((Object)userIdentity);
        Claims claims = Jwts.claims();
        claims.put((Object)"userinfo", (Object)userJson);
        Date expiration = null;
        expiration = ttl > 0 ? DateUtils.addMilliseconds((Date)now, (int)ttl) : (ttl == -1 ? DateUtils.addHours((Date)now, (int)87600) : DateUtils.addHours((Date)now, (int)168));
        String base64EncodedSecretKey = Base64Utils.encodeToString((byte[])secretKey.getBytes());
        JwtBuilder builder = Jwts.builder().compressWith(CompressionCodecs.GZIP).setHeader((Map)jwsHeader).setClaims(claims).setExpiration(expiration).signWith(signatureAlgorithm, base64EncodedSecretKey);
        return builder.compact();
    }

    public static String encode(JWTContext jwtContent, int ttl, String secretKey) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS512;
        Date now = new Date();
        HashMap jwsHeader = Maps.newHashMap();
        jwsHeader.put("alg", signatureAlgorithm.getValue());
        jwsHeader.put("kid", jwtContent.getAccount());
        jwsHeader.put("typ", jwtContent.getIdentityType());
        jwsHeader.put("ttl", jwtContent.getTtl());
        jwsHeader.put("tenantCode", jwtContent.getTenantCode());
        JSONObject userJson = jwtContent.getUserInfo();
        Claims claims = Jwts.claims();
        claims.put((Object)"userinfo", (Object)userJson);
        Date expiration = null;
        expiration = ttl > 0 ? DateUtils.addMilliseconds((Date)now, (int)ttl) : (ttl == -1 ? DateUtils.addHours((Date)now, (int)87600) : DateUtils.addHours((Date)now, (int)168));
        String base64EncodedSecretKey = Base64Utils.encodeToString((byte[])secretKey.getBytes());
        JwtBuilder builder = Jwts.builder().compressWith(CompressionCodecs.GZIP).setHeader((Map)jwsHeader).setClaims(claims).setExpiration(expiration).signWith(signatureAlgorithm, base64EncodedSecretKey);
        return builder.compact();
    }

    public static JWTContext decode(String jwt, String secretKey) throws JwtException, IllegalArgumentException {
        String base64EncodedSecretKey = Base64Utils.encodeToString((byte[])secretKey.getBytes());
        Jwt decodeJwt = Jwts.parser().setSigningKey(base64EncodedSecretKey).parse(jwt);
        Header header = decodeJwt.getHeader();
        Validate.notNull((Object)header.get((Object)"kid"), (String)"not jwt KEY_ID !!", (Object[])new Object[0]);
        String account = header.get((Object)"kid").toString();
        Validate.notNull((Object)header.get((Object)"typ"), (String)"not jwt TYPE !!", (Object[])new Object[0]);
        String identityType = header.get((Object)"typ").toString();
        Validate.notNull((Object)header.get((Object)"tenantCode"), (String)"not jwt tenantCode !!", (Object[])new Object[0]);
        String tenantCode = header.get((Object)"tenantCode").toString();
        Integer ttl = Objects.nonNull(header.get((Object)"ttl")) ? Integer.valueOf(Integer.parseInt(header.get((Object)"ttl").toString())) : null;
        Claims claims = (Claims)decodeJwt.getBody();
        Object userinfoValue = claims.get((Object)"userinfo");
        Validate.notNull((Object)userinfoValue, (String)"jwt userinfo is null", (Object[])new Object[0]);
        JSONObject userObject = (JSONObject)JSONObject.toJSON((Object)userinfoValue);
        Date expiration = claims.getExpiration();
        return new JWTContext(tenantCode, identityType, account, userObject, expiration, ttl);
    }
}

