/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.sdk.vo;

import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class LoginDetails
extends WebAuthenticationDetails {
    private static final long serialVersionUID = -8450931284609163341L;
    private Integer type = null;
    private String tenantCode;
    private String username;
    private String account;
    private String password;
    private String checkCode;
    private String smsVerificationCode;
    private String phone;
    private String sessionId;

    public LoginDetails(HttpServletRequest request) {
        super(request);
        String typeValue = request.getParameter("type");
        if (!StringUtils.isBlank((CharSequence)typeValue) && this.isNumeric(typeValue)) {
            this.type = Integer.parseInt(typeValue);
        }
        this.tenantCode = request.getParameter("tenantCode");
        if (StringUtils.isNotBlank((CharSequence)this.tenantCode)) {
            TenantContextHolder.setTenant((String)this.tenantCode);
        }
        this.sessionId = request.getSession().getId();
        this.username = request.getParameter("username");
        this.account = request.getParameter("account");
        this.password = request.getParameter("password");
        this.checkCode = request.getParameter("checkCode");
        this.smsVerificationCode = request.getParameter("smsVerificationCode");
        this.phone = request.getParameter("phone");
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^[0-9]+$");
        return pattern.matcher(str).find();
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getSmsVerificationCode() {
        return this.smsVerificationCode;
    }

    public void setSmsVerificationCode(String smsVerificationCode) {
        this.smsVerificationCode = smsVerificationCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String toString() {
        return "LoginDetails [type=" + this.type + ", account=" + this.account + ", username=" + this.username + ", password=" + this.password + ", checkCode=" + this.checkCode + ", smsVerificationCode=" + this.smsVerificationCode + ", phone=" + this.phone + ", sessionId=" + this.sessionId + "]";
    }
}

