package com.bizunited.nebula.security.sdk.config;

import javax.servlet.Filter;

/**
 * 在业务系统开发过程中，二次开发团队经常需要让一些filter在spring security之后被运行。
 * 这是二次开发团队就只需要实现该接口，并将需要运行的filter对象设置进去，这样这些filter的逻辑就可以在spring security工作之后被运行</br>
 * 具体来说是在FilterSecurityInterceptor成功运行之后开始运行
 * @author yinwenjie
 */
@FunctionalInterface
public interface CustomFilterAfterConfig {
  public Filter getCustomFilterAfter();
}
