package com.bizunited.nebula.security.sdk.config;

import org.springframework.security.config.annotation.web.builders.HttpSecurity;

/**
 * 定义的应用权限配置的接口，此接口的定义便于应用自定义配置权限
 * @Author: Paul Chan
 * @Date: 2020-04-08 15:46
 */
@FunctionalInterface
public interface NebulaWebSecurityConfigurerAdapter {

  /**
   * 配置http的安全认证，此方法会在nebula的权限配置完成后调用
   * 目前nebula调用此接口的方法有com.bizunited.empower.terminal.mini.configuration.CustomSecurityConfig#configure
   * @param http
   * @throws Exception
   */
  void configure(HttpSecurity http) throws Exception;

}
