package com.bizunited.nebula.security.sdk.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * TODO 注释未写
 * @author yinwenjie
 */
@Component
@ConfigurationProperties(prefix = "security")
public class PasswordValidateProperties {
  /**
   * 通过该参数，基于正则表达式设定密码强度
   */
  private String passwordStrength;
  /**
   * 当密码创建/修改时，如果密码强度不符合预期，该如何进行提示
   */
  private String tips;
  /**
   * 该参数可设定密码的最小长度（0或者负数，表示不做限制；默认为0）
   */
  private int passwordMinLength = 0;
  /**
   * 该参数可设定密码的最小特殊字符数量（默认为0）
   */
  private int passwordMinSpecialChartLength = 0;
  /**
   * 该参数可设定密码的最小数字字符数量（默认为0）
   */
  private int passwordMinNumericLength = 0;
  /**
   * 该参数可设定密码的最小字母字符数量（默认为0）
   */
  private int passwordMinChartLength = 0;
  
  public String getPasswordStrength() {
    return passwordStrength;
  }
  public void setPasswordStrength(String passwordStrength) {
    this.passwordStrength = passwordStrength;
  }
  public String getTips() {
    return tips;
  }
  public void setTips(String tips) {
    this.tips = tips;
  }
  public int getPasswordMinLength() {
    return passwordMinLength;
  }
  public void setPasswordMinLength(int passwordMinLength) {
    this.passwordMinLength = passwordMinLength;
  }
  public int getPasswordMinSpecialChartLength() {
    return passwordMinSpecialChartLength;
  }
  public void setPasswordMinSpecialChartLength(int passwordMinSpecialChartLength) {
    this.passwordMinSpecialChartLength = passwordMinSpecialChartLength;
  }
  public int getPasswordMinNumericLength() {
    return passwordMinNumericLength;
  }
  public void setPasswordMinNumericLength(int passwordMinNumericLength) {
    this.passwordMinNumericLength = passwordMinNumericLength;
  }
  public int getPasswordMinChartLength() {
    return passwordMinChartLength;
  }
  public void setPasswordMinChartLength(int passwordMinChartLength) {
    this.passwordMinChartLength = passwordMinChartLength;
  }
}
