package com.bizunited.nebula.security.sdk.config;

import com.bizunited.nebula.security.sdk.constant.Constants;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 有nebula 2.4+版本开始提供的经典登录权限认证的配置信息</br>
 * 该模块只依赖nebula的另外三个模块（不存在循环依赖） nebula.user->nebula.rbac->nebula.core</br>
 * 您可以根据实际情况，替换掉该模块（自行实现登录功能）。
 * @author yinwenjie
 */
@Component
@ConfigurationProperties(prefix = "security")
public class SimpleSecurityProperties {
  /**
   * 忽略权限判断的url（且不参与tenantCode的过滤和appCode的过滤）
   */
  private String[] ignoreUrls;
  /**
   * 当启用白名单时，也要尽量识别和转换JWT信息
   */
  private Boolean ignoreUrlsButJwt = true;
  /**
   * 忽略权限判断url（但是要参与tenantCode过滤）
   */
  private String[] ignoreUrlsButFilterTenantCode;
  /**
   * 忽略权限判断的url（但是要参与appCode过滤）
   */
  private String[] ignoreUrlsButFilterAppCode;
  /**
   * 登录操作地址
   */
  private String loginUrl;
  /**
   * 登录成功跳转页面
   */
  private String loginPageUrl;
  /**
   * 登出操作地址
   */
  private String logoutUrl;
  /**
   * 登出成功后跳转页面
   */
  private String logoutSuccessRedirect = "";
  /**
   * 如果当前登录信息中，登录方式缺失，则使用该默认值（默认为1）
   */
  private Integer defaultLoginType = 1;
  /**
   * 系统是否允许匿名访问，在没有JWT信息的情况下
   */
  private Boolean allowAnonymous = false;
  /**
   * 独立身份有利于存在新生成线程的工作场景，在新线程工作时，为线程上下文写入一个可识别的用户信息</br>
   * 例如：定时任务模块，初始化模块等等
   */
  private String independencyUser = "admin";
  /**
   * 独立身份有利于存在新生成线程的工作场景，在新线程工作时，为线程上下文写入一个可识别的角色身份信息，多个以“,”分割</br>
   * 例如：定时任务模块，初始化模块等等</br>
   * independencyUser属性和independencyAdmins属性，要么都配置值，要么都不配置值
   */
  private String[] independencyRoles = new String[] {"ADMIN"};
  /**
   * 设定的jwt密钥
   */
  private String secretKey = "123456";
  /**
   * jwtToken的有效时长(单位毫秒)，如果不传入或者传入为小于1的数，则有效时长为168小时
   */
  private int jwtttl = 0;
  /**
   * jwtToken有效时间在剩余多少时间(单位毫秒)的时候有操作时刷新jwt信息,默认5分钟
   */
  private int jwtRefreshTime = Constants.DEFAULT_JWT_REFRESH_TIME;
  /**
   * 那些系统默认存在的，需要忽略权限判定的地址
   */
  public static final String[] DEFAULT_IGNOREURLS = new String[] {"/default/**","/static/**"};
  
  public String[] getIgnoreUrls() {
    return ignoreUrls;
  }
  public void setIgnoreUrls(String[] ignoreUrls) {
    this.ignoreUrls = ignoreUrls;
  }
  public String[] getIgnoreUrlsButFilterTenantCode() {
    return ignoreUrlsButFilterTenantCode;
  }
  public void setIgnoreUrlsButFilterTenantCode(String[] ignoreUrlsButFilterTenantCode) {
    this.ignoreUrlsButFilterTenantCode = ignoreUrlsButFilterTenantCode;
  }
  public String[] getIgnoreUrlsButFilterAppCode() {
    return ignoreUrlsButFilterAppCode;
  }
  public void setIgnoreUrlsButFilterAppCode(String[] ignoreUrlsButFilterAppCode) {
    this.ignoreUrlsButFilterAppCode = ignoreUrlsButFilterAppCode;
  }
  public String getLoginUrl() {
    return loginUrl;
  }
  public void setLoginUrl(String loginUrl) {
    this.loginUrl = loginUrl;
  }
  public String getLoginPageUrl() {
    return loginPageUrl;
  }
  public void setLoginPageUrl(String loginPageUrl) {
    this.loginPageUrl = loginPageUrl;
  }
  public String getLogoutUrl() {
    return logoutUrl;
  }
  public void setLogoutUrl(String logoutUrl) {
    this.logoutUrl = logoutUrl;
  }
  public String getLogoutSuccessRedirect() {
    return logoutSuccessRedirect;
  }
  public void setLogoutSuccessRedirect(String logoutSuccessRedirect) {
    this.logoutSuccessRedirect = logoutSuccessRedirect;
  }
  public Integer getDefaultLoginType() {
    return defaultLoginType;
  }
  public void setDefaultLoginType(Integer defaultLoginType) {
    this.defaultLoginType = defaultLoginType;
  }
  public String getIndependencyUser() {
    return independencyUser;
  }
  public void setIndependencyUser(String independencyUser) {
    this.independencyUser = independencyUser;
  }
  public String[] getIndependencyRoles() {
    return independencyRoles;
  }
  public void setIndependencyRoles(String[] independencyRoles) {
    this.independencyRoles = independencyRoles;
  }
  public String getSecretKey() {
    return secretKey;
  }
  public void setSecretKey(String secretKey) {
    this.secretKey = secretKey;
  }
  public int getJwtttl() {
    return jwtttl;
  }
  public void setJwtttl(int jwtttl) {
    this.jwtttl = jwtttl;
  }
  public Boolean getAllowAnonymous() {
    return allowAnonymous;
  }
  public void setAllowAnonymous(Boolean allowAnonymous) {
    this.allowAnonymous = allowAnonymous;
  }
  public Boolean getIgnoreUrlsButJwt() {
    return ignoreUrlsButJwt;
  }
  public void setIgnoreUrlsButJwt(Boolean ignoreUrlsButJwt) {
    this.ignoreUrlsButJwt = ignoreUrlsButJwt;
  }

  public int getJwtRefreshTime() {
    return jwtRefreshTime;
  }

  public void setJwtRefreshTime(int jwtRefreshTime) {
    this.jwtRefreshTime = jwtRefreshTime;
  }
}
