package com.bizunited.nebula.security.sdk.constant;

/**
 * 在nebula-security模块使用的的常量信息
 * @author: yinwenjie
 */
public class Constants {

  private Constants() {
    throw new IllegalStateException("静态变量类不能实例化！");
  }
  
  /**
   * 登录账号锁（用作多次登录失败的记录）
   * 第一个参数：登录账号
   */
  public static final String LOGIN_ACCOUNT_LOCK = "lock:login:account:%s";

  /**
   * jwtToken有效时间在剩余多少时间(单位毫秒)的时候有操作时刷新jwt信息,默认5分钟
   */
  public static final Integer DEFAULT_JWT_REFRESH_TIME = 5 * 60 * 1000;
}
