package com.bizunited.nebula.security.sdk.event;

import java.util.Set;

import com.bizunited.nebula.security.sdk.loginform.LoginDetails;

/**
 * spring security被nebula封装以后，需要向上层模块暴露相关的事件监听。这里事件一般为要求上层用户模块进行订阅的事件</br>
 * @author yinwenjie
 */
public interface AuthenticationUserEventListener {
  
  /**
   * 当本次登录鉴权过程中，nebula-security组件需要获取当前登陆者所具备的角色（roleCode）时，该事件被触发.
   * @param tenantCode 当前登录者的二级租户信息
   * @param account 当前登录者的账号信息。注意，有的时候登录并不是依靠account信息完成的。
   * @param loginDetails 当前登录者的表单信息
   * @return
   */
  default Set<String> onRequestRoleCodes(String tenantCode , String account , LoginDetails loginDetails) {
    return null;
  }
  
  /**
   * 如果触发的onRequestRoleCodes(String tenantCode , String account , Authentication authentication)返回为空（或者空集合），那么方法将被触发。
   * @param tenantCode 当前登录者的二级租户信息
   * @param account 当前登录者的账号信息。注意，有的时候登录并不是依靠account信息完成的。
   * @return 返回的角色业务编号信息，将用于鉴权工作后续的功能
   * @deprecated 该方法在2.4.3.0中，已被启用，建议实现 onRequestRoleCodes(String tenantCode , String account , LoginDetails loginDetails)方法
   */
  @Deprecated
  default Set<String> onRequestRoleCodes(String tenantCode , String account) {
    return null;
  }
}