package com.bizunited.nebula.security.sdk.event;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.core.Ordered;
import org.springframework.security.core.Authentication;

/**
 * 在各种业务系统登录成功后，往往会根据系统自身的要求，向请求者（客户端）返回各种不同的带有业务的信息。
 * 该接口正好用于满足这些要求，通过对SuccessPrinterContext上下文中内容的干预，最终返回各种业务系统需要用到的信息</p>
 * 
 * 注意如果存在多个NebulaSecurityAuthenticationSuccessPrinter接口的实现，那么这些实现都将按照顺序依次执行。
 * 最终返回的内容，是这些信息的累加
 * 
 * @author yinwenjie
 */
public interface NebulaSecurityAuthenticationSuccessPrinter extends Ordered {
  /**
   * @param successPrinterContext 需要返回内容的上下文信息
   * @param request 本次登录请求操作request信息
   * @param response 本次登录请求操作的response信息
   * @param authentication 身份对象
   */
  public void print(SuccessPrinterContext successPrinterContext , HttpServletRequest request, HttpServletResponse response , Authentication authentication);
}
