package com.bizunited.nebula.security.sdk.login;

import com.bizunited.nebula.security.sdk.loginform.LoginDetails;

/**
 * 鉴权决策器，目前支持六种。当验证过程发生时，该策略被触发
 * @author yinwenjie
 */
public interface AuthenticationDecisionStrategy {
  /**
   * 该方法返回当前实现的对应的认证类型：</br>
   * 1、典型的用户名+密码方式；</br>
   * 2、典型的用户名 + 密码 + 校验码方式；</br>
   * 3、用户名 + 短信验证码 + 校验码方式；</br> 
   * 4、手机号 + 密码方式；</br>
   * 5、手机号 + 短信验证码；</br>
   * 6、手机号 + 短信验证码 + 校验码方式</p> 
   * 当然，还可以自己给定登录方式的代码</p>
   * 
   * 标品的实现中，该值是一个枚举，但最终返回的是一个数字。项目上面可以使用6以后的数字代表登录方式，具体参见DecisionTypes
   */
  public Integer type();
  /**
   * 在登录表单完成转换后，该方法是进行登录鉴权操作和最终登录者用户身份创建的地方，
   * 最终将转换成一个用户信息，并进行返回，例如厂商用户、经销商用户、C端用户。</p>
   * 
   * 如果在登录者身份信息生成时出现问题，直接抛出运行时异常即可。系统会认为本次登录失败</p>
   * 
   * @param loginFormDetails 当前登录操作使用的表单信息
   * @param type 参见type() 方法的说明
   * 
   * @return 登录成功后得到的用户身份描述信息，将被返回。如果返回为null或者抛出异常，则认为认证过程失败
   */
  public UserIdentity decide(LoginDetails loginFormDetails , Integer type); 
}

