package com.bizunited.nebula.security.sdk.login;

import java.io.Serializable;

/**
 * 这就是已经完成用户身份认证后，在系统中用于描述操作者信息的顶级接口。
 * 不同的操作主体，需要分别实现该接口：例如厂商用户、经销商用户、C端用于，又或者
 * @author yinwenjie
 *
 */
public interface UserIdentity extends Serializable {
  /**
   * 登录者身份类型。例如如果是厂商用户，可以标识为：fac；如果是经销商，可以标识为：dest。
   * 该值非常关键，在登陆者跨子系统进行信息请求时，不同系统将根据该属性完成不同身份用户之间的转换。
   * @return
   */
  public String getIdentityType();
  /**
   * 当前用户身份认证时，所使用的登录方式
   * （参见LoginDetails中的type属性）
   * @return
   */
  public Integer getLoginType();
  /**
   * 租户信息是所有具体的用户模型中，必须存在的一个属性</br>
   * 该值非常关键，各个子系统将根据该值确认当前操作的二级租户信息
   * @return
   */
  public String getTenantCode();
  /**
   * 登录者唯一账号信息，是所有具体的用户模型中，必须存在的一个属性
   * @return
   */
  public String getAccount();
  /**
   * 进行登录者身份描述的信息中，一定存在角色信息
   * @return
   */
  public String[] getRoleCodes();
}
