package com.bizunited.nebula.security.sdk.loginform;

/**
 * 该类描述了登录操作时传递的自定义表单信息
 * @author yinwenjie
 */
public interface LoginDetails { 
  /**
   * 登录方式类型：1、典型的用户名+密码方式；2、典型的用户名 + 密码 + 校验码方式；3、用户名 + 短信验证码 + 校验码方式；
   * 4、手机号 + 密码方式；5、手机号 + 短信验证码；6、手机号 + 短信验证码 + 校验码方式</br>
   * 当然，这里type也可以为null或者小于等于0的一个数，这种情况下，登录逻辑将采用第1中鉴权方式（请参见SimpleSecurityProperties配置描述中的defaultLoginType属性）</p>
   * 
   * 登录方式是所有具体的用户模型中，必须存在的一个属性
   * @return
   */
  public Integer getType();
  /**
   * 登录者唯一账号信息，是所有具体的用户模型中，必须存在的一个属性
   * @return
   */
  public String getAccount();
  /**
   * 登录者密码信息(明文)，不是所有具体的用户模型中，必须存在的一个属性
   * @return
   */
  public String getPassword();
  /**
   * 登录者用户名信息，不是所有具体的用户模型中，必须存在的一个属性
   * @return
   */
  public String getUsername();
  /**
   * 登录者电话信息，不是所有具体的用户模型中，必须存在的一个属性
   * @return
   */
  public String getPhone();
}