package com.bizunited.nebula.security.sdk.loginform;

import javax.servlet.http.HttpServletRequest;

/**
 * 登录表单信息的验证和转换策略。帮助特定type（登录类型）的表单进行表单的初步验证和转换
 * @author yinwenjie
 */
public interface LoginValidateStrategy {
  /**
   * matched方法返回true，说明当前登录表单类型（type）可以由本策略完成表单的初步验证和对象转换
   * @param request http request请求信息
   * @param type 当前的登录类型，
   * @return
   */
  public boolean matched(HttpServletRequest request , Integer type);
  
  /**
   * 进行登录表单的转换 
   * @param request 
   * @return 
   */
  public LoginDetails validateAndTransform(HttpServletRequest request);
}

