package com.bizunited.nebula.security.sdk.password;

/**
 * 2022-12-04 多个项目提出，项目需要在使用密码登录时，通过统一的密码校验配置，进行密码规则校验过程。</br>
 * 所以在这里提供相关配置，指定当前登录策略是否要根据统一的密码校验配置，专门验证密码强度
 * @author yinwenjie
 */
public interface PasswordValidateService {
  /**
   * 传入一个经过解密的明文密码信息（字符串），nebula security将基于目前设定的统一密码强度规则，对当前的密码字符串进行验证</br>
   * 使用场景主要就是进行各种用户创建时，进行密码的合规性的验证（设置方式示例为）：</p>
   * 
   * tips: 密码格式不符合要求，密码长度至少11为，且其中必须有5为数字，2为特殊字符
   * passwordMinLength: 11
   * passwordMinSpecialChartLength：2
   * passwordMinNumericLength：5
   * passwordMinChartLength: 0
   * passwordStrength: ""
   * @param password 
   */
  public void validate(String password);
}
