package com.bizunited.nebula.security.sdk.refresh;

import org.springframework.core.Ordered;

import com.bizunited.nebula.security.sdk.login.UserIdentity;

/**
 * 调用AuthenticationUserService.refreshAuthentication方法，
 * 将会触发本接口的某个具体实现逻辑，完成对当前线程中用户身份上下文securityContext的初始化/刷新过程
 * @author yinwenjie
 *
 */
public interface AuthenticationRefreshStrategy extends Ordered {
  /**
   * 针对AuthenticationUserService.refreshAuthentication方法传入的参数，
   * 确定调用者进行用户身份刷新的操作，是否可以由本逻辑完成。
   * @param userInfo 请参见LoginUserService.refreshAuthentication方法的描述
   * @return 如果匹配则返回true；其余情况返回false
   */
  boolean matched(Object userInfo);
  
  /**
   * 如果matched返回true，则该方法将被触发。
   * @param userInfo 
   * @return 初始化后的用户身份信息将需要返回，如果返回null，系统将认为不进行任何用户身份信息的处理</br>
   * 注意，返回的UserIdentity对象中，其中的account、tenantCode、rolesCodes都是必须要进行设定的
   */
  UserIdentity refresh(Object userInfo);
}
