package com.bizunited.nebula.security.sdk.transform;

import org.springframework.core.Ordered;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

/**
 * 用户身份转换策略：基于JWT工作的子系统和子系统的调用过程中。需要进行用户身份的转换。
 * 举个例子：DMS电商系统，其使用主体是经销商用户；而TPM预算子系统的使用主体是厂商用户。这个时候，如果DMS电商系统在下单的时候，调用TPM预算子系统的API；
 * 那么TPM预算系统就需要找到经销商用户和厂商用户的身份转换方式。</p>
 * 
 * 而该策略接口就是为了完成这样的转换动作。一旦转换成功，不同使用主体的系统就可以建立调用关系；简单的处理过程也可以是：无论哪个子系统进行本子系统API的调用，
 * 都认为是具有本系统管理员身份的用户在进行操作：可参见SimpleSecurityProperties配置信息中关于independencyUser属性和independencyRoles属性的描述</p>
 * 
 * 但是，以上粗暴的做法并不推荐。
 * 
 * @author yinwenjie
 *
 */
public interface IdentityTransformStrategy extends Ordered {
  /**
   * 通过JWT信息解析调用方的源用户身份类型，以便确认某一个具体的转换策略是否支持对这种用户身份类型的转换。
   * @param sourceIdentityType 
   * @return
   */
  public boolean matched(String sourceIdentityType);
  
  /**
   * 如果matched返回为true，那么该转换策略方法将被触发正式开始工作，以便完成正式的用户身份转换过程
   * @param sourceIdentityType 源请求中携带的用户身份类型
   * @param sourceTenantCode 源请求中携带的用户二级租户信息
   * @param sourceAccount 源请求中携带的源用户账户信息
   * @param userObject 通过JWT解析得到的源请求中携带用户身份信息详细情况（使用json结构进行描述）
   * @return 基于源信息构建成功后的本系统的用户身份对象，将进行返回
   */
  public UserIdentity transform(String sourceIdentityType , String sourceTenantCode , String sourceAccount , JSONObject userObject);
}
