package com.bizunited.nebula.security.sdk.transform;

import com.bizunited.nebula.security.sdk.login.UserIdentity;

/**
 * 在操作者A进行登录后，在其操作过程中，可能他的用户身份被其他操作人员进行了修改，导致当前操作人A不再能够进行系统操作。
 * 这个时候系统需要强制操作者A退出操作（到登陆页面或者提示页面），而该接口的具体实现类，就是用于做这个事情的。</p>
 * 
 * 请注意，该接口的方法触发的频度较高，所以为了保证性能，建议在具体实现中使用本地缓存保存最近已经完成验证的用户身份信息（例如最近10秒内）
 * 以便有效减轻数据持久层的操作频度
 * 
 * @author yinwenjie
 *
 */
public interface IdentityTransformValidate {
  /**
   * 该方法用于判定特定的验证策略是否支持某种特定的用户身份类型
   * @param userIdentity 当前登录者信息，注意，不可通过security上下文取得，因为在特定情况下（例如从JWT识别登录信息时）security上下文可能还没有正确的用户信息 
   * @return 
   */
  public boolean matched(UserIdentity userIdentity);
  
  /**
   * 如果matched返回true，则该方法将会运行(推荐使用各种用户信息的最后一次登录时间和最后一次修改时间，进行判定)
   * @return 如果判定当前用户在登录后，其主要的用户信息已经被管理员或有权限的人员进行了修改，则该方法直接抛出异常即可
   */
  public void validate(UserIdentity userIdentity);
}
