package com.bizunited.nebula.table.sdk.dto.visibility;

import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2023年03月24日 09:59:00
 */
public class TableVisibilityDto  {

  @ApiModelProperty(name = "id", value = " ID")
  private String id;

  @ApiModelProperty(name = "visibilityName", value = "可见性名称")
  private String visibilityName;

  /**
   * 页面编码
   */
  @ApiModelProperty(name = "templateCode", value = "页面编码")
  private String templateCode;

  /**
   * 可见性优先级
   */
  @ApiModelProperty(name = "templateCode", value = "可见性优先级")
  private int priority;

  /**
   * 可见性条件表达式整体
   */
  @ApiModelProperty(name = "expressionStr", value = "可见性条件表达式整体")
  private String expressionStr;

  /**
   * 可见性条件表达式关系映射
   */
  @ApiModelProperty(name = "conditionMapping", value = "可见性条件表达式关系映射")
  private String conditionMapping;


  /**
   * 可见性条件表达式带前端JSON样式
   */
  @ApiModelProperty(name = "expressionStr", value = "可见性条件表达式带前端JSON样式")
  private String expressionJson;

  /**
   * 可见性条件表达式计算方法
   */
  @ApiModelProperty(name = "expressionStr", value = "可见性条件表达式计算方法")
  private String calculationMethod;

  /**
   * 组件信息集合
   */
  private List<TableVisibilityComponentDto> components;

  public String getConditionMapping() {
    return conditionMapping;
  }

  public void setConditionMapping(String conditionMapping) {
    this.conditionMapping = conditionMapping;
  }

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }

  public String getVisibilityName() {
    return visibilityName;
  }

  public void setVisibilityName(String visibilityName) {
    this.visibilityName = visibilityName;
  }

  public String getTemplateCode() {
    return templateCode;
  }

  public void setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
  }

  public int getPriority() {
    return priority;
  }

  public void setPriority(int priority) {
    this.priority = priority;
  }

  public String getExpressionStr() {
    return expressionStr;
  }

  public void setExpressionStr(String expressionStr) {
    this.expressionStr = expressionStr;
  }

  public String getCalculationMethod() {
    return calculationMethod;
  }

  public void setCalculationMethod(String calculationMethod) {
    this.calculationMethod = calculationMethod;
  }

  public List<TableVisibilityComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<TableVisibilityComponentDto> components) {
    this.components = components;
  }

  public String getExpressionJson() {
    return expressionJson;
  }

  public void setExpressionJson(String expressionJson) {
    this.expressionJson = expressionJson;
  }

}

