package com.bizunited.nebula.table.sdk.event;

import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import com.bizunited.nebula.table.sdk.dto.visibility.TableVisibilityStrategyEvenDto;
import com.bizunited.nebula.table.sdk.vo.visibility.TableVisibilityStrategyExecuteEventResponse;
import com.bizunited.nebula.table.sdk.vo.visibility.TableVisibilityStrategyInfoEventResponse;

/**
 * @author HanJiaJun
 * @describe:  可见性事件监听 主要在每个子系统找NebulaTableVisibilityStrategy的实现类
 * @createTime 2023年03月25日 10:52:00
 */
public interface NebulaTableVisibilityEventListener extends NebulaEvent {
  /**
   * 远程获取策略基本信息
   */

  TableVisibilityStrategyInfoEventResponse getStrategyInfoEventVoList(TableVisibilityStrategyEvenDto dto);



  /**
   * 可见性执行
   */
  TableVisibilityStrategyExecuteEventResponse execute(TableVisibilityStrategyEvenDto dto);

  /**
   * 可见性检测（预执行）
   */
  TableVisibilityStrategyExecuteEventResponse preExecute(TableVisibilityStrategyEvenDto dto);
}
