package com.bizunited.nebula.table.sdk.service.visibility;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.table.sdk.vo.visibility.TableVisibilityStrategyInfoVo;

import java.util.HashMap;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2023年03月24日 15:26:00
 */
public interface TableVisibilityStrategyVoService {
   /**
    * 获取可见性策略器集合
    * @param name
    * @return
    */
   List<TableVisibilityStrategyInfoVo> getVisibilityStrategy(String name) ;

   /**
    * 获取可见性操作符策略器集合
    * @param name
    * @return
    */
   List<TableVisibilityStrategyInfoVo> getOperatorStrategy(String name);

  /**
   * 可见性执行接口
   * 执行过程：
   * 1. 查询可见性（按优先级排序）
   * 2. 从当前可见性中提取信息，执行可见性策略，分别计算每一个策略的结果
   * 3. 将第二步每一个可见性策略结果放进表达式，计算最终表达式结果
   * 4. 最终结果命中true，即返回！
   * @param templateCode
   * @return
   */
  JSONArray execute(String templateCode);

  /**
   * 可见性预执行
   * 执行过程与执行接口execute()一致
   * 区别就是，预执行所需参数需要手动传入，预执行并不会从环境上下文中取值
   * @param map
   * @return
   */
  JSONArray preExecute(JSONObject map);
}
