package com.bizunited.nebula.table.sdk.strategy;

import com.alibaba.fastjson.JSONObject;

/**
 * @author HanJiaJun
 * @describe: 可见性逻辑实现
 * @createTime 2023年03月23日 11:25:00
 */
public interface NebulaTableVisibilityStrategy {
  /**
   * 编码 系统唯一
   * @return
   */
  String getVisibilityCode();

  /**
   * 名称 用于前端展示
   * @return
   */
  String getVisibilityName();


  /**
   * 排序
   * @return
   */
  int sort();

  /**
   * 执行
   * @param parameter 可见性设置的条件参数
   * @return
   */
  Boolean match(JSONObject parameter);

  /**
   * 预执行
   * @param preParameter  预执行设置的入参
   * @param parameter   可见性设置的条件参数
   * @return
   */
  Boolean preMatch(JSONObject preParameter,JSONObject parameter);
}
