package com.bizunited.nebula.table.sdk.vo.menu;

import com.bizunited.nebula.common.vo.UuidOpVo;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2023年03月09日 17:26:00
 */
public class TableMenuVo extends UuidOpVo {
  @ApiModelProperty(name="menuCode" , value="菜单编码")
  private String menuCode;
  /** 功能备注（功能中文名）. **/
  @ApiModelProperty(name = "menuDesc", value = "备注", required = true)
  private String menuDesc ;
  /** 当前功能项是否显示在菜单树中 */
  @ApiModelProperty(name="viewItem" , value="当前功能项是否显示在菜单树中 1：显示的菜单树；0：不显示在菜单树" , required=true)
  private Integer viewItem = 0;
  /** 状态 1正常, 0禁用（枚举）. **/
  @ApiModelProperty(name="tstatus" , value="状态 1正常, 0禁用（枚举）", required=true)
  private Integer tstatus = 1;
  /** 功能排序信息，数字越大排序越靠后 */
  private Integer sortIndex = 100;

  private String parentCode;

  private TableMenuVo parent;

  private List<TableMenuVo> children ;

  /**
   * 数据来源
   */
  @Column(name = "data_source",  columnDefinition = "varchar(32) COMMENT '数据来源'")
  private String dataSource;


  public TableMenuVo getParent() {
    return parent;
  }

  public void setParent(TableMenuVo parent) {
    this.parent = parent;
  }

  public List<TableMenuVo> getChildren() {
    return children;
  }

  public void setChildren(List<TableMenuVo> children) {
    this.children = children;
  }

  public String getMenuCode() {
    return menuCode;
  }

  public void setMenuCode(String menuCode) {
    this.menuCode = menuCode;
  }

  public String getMenuDesc() {
    return menuDesc;
  }

  public void setMenuDesc(String menuDesc) {
    this.menuDesc = menuDesc;
  }

  public Integer getViewItem() {
    return viewItem;
  }

  public void setViewItem(Integer viewItem) {
    this.viewItem = viewItem;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getDataSource() {
    return dataSource;
  }

  public void setDataSource(String dataSource) {
    this.dataSource = dataSource;
  }
}
