/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.config;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Configuration
@EntityScan(basePackages={"com.bizunited.nebula.task.local.entity"})
@EnableJpaRepositories(basePackages={"com.bizunited.nebula.task.local.repository"})
@ComponentScan(basePackages={"com.bizunited.nebula.task"})
@Component(value="_schedulerConfig")
@EnableElasticsearchRepositories(basePackages={"com.bizunited.nebula.task.local.log"})
public class SchedulerAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean(value={"platform_dTaskMasterKeeperThreadExecutor"})
    public ThreadPoolExecutor getDynamicTaskMasterKeeperThreadExecutor() {
        ThreadPoolExecutor dynamicTaskMasterKeeperThreadExecutor = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "platform_DynamicTask_MasterKeeperThread_" + this.count.incrementAndGet());
                ClassLoader classLoader = SchedulerAutoConfiguration.this.applicationContext.getClassLoader();
                thread.setContextClassLoader(classLoader);
                thread.setDaemon(false);
                return thread;
            }
        });
        return dynamicTaskMasterKeeperThreadExecutor;
    }

    @Bean(value={"platform_dynamicTaskLoadingThreadScheduler"})
    public ThreadPoolTaskScheduler getInitProcessThreadPoolExecutor() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setBeanName("platform_dynamicTaskMSThreadScheduler");
        scheduler.setDaemon(false);
        scheduler.setPoolSize(50);
        scheduler.setThreadFactory(new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                ClassLoader classLoader = SchedulerAutoConfiguration.this.applicationContext.getClassLoader();
                currentThread.setDaemon(false);
                currentThread.setName("platform_DynamicTask_LoadingThread_" + this.count.getAndIncrement());
                currentThread.setContextClassLoader(classLoader);
                return currentThread;
            }
        });
        scheduler.setThreadNamePrefix("platform_dynamicTaskMSThreadScheduler_");
        return scheduler;
    }

    @Bean(value={"platform_dynamicTaskScheduler"})
    public ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setBeanName("platform_dynamicTaskScheduler");
        scheduler.setDaemon(false);
        scheduler.setPoolSize(50);
        scheduler.setThreadFactory(new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                ClassLoader classLoader = SchedulerAutoConfiguration.this.applicationContext.getClassLoader();
                currentThread.setDaemon(false);
                currentThread.setName("platform_DynamicTask_" + this.count.getAndIncrement());
                currentThread.setContextClassLoader(classLoader);
                return currentThread;
            }
        });
        scheduler.setThreadNamePrefix("platform_");
        return scheduler;
    }
}

