package com.bizunited.nebula.task.local.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 和动态任务的
 * @author yinwenjie
 */
@Component
@ConfigurationProperties(prefix = "task")
public class DynamicTaskProperties {
  /**
   * 动态任务执行器，为了避免多节点执行所使用的锁名字
   */
  private String dynamicTaskLockKey = "REDIS_LOCK_KEY_DYNAMICTASK";
  /**
   * spring boot应用程序名
   */
  @Value("${spring.application.name}")
  private String applicationName;

  public String getDynamicTaskLockKey() {
    return dynamicTaskLockKey;
  }
  public void setDynamicTaskLockKey(String dynamicTaskLockKey) {
    this.dynamicTaskLockKey = dynamicTaskLockKey;
  }
  public String getApplicationName() {
    return applicationName;
  }
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }
}
