package com.bizunited.nebula.task.local.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.nebula.common.entity.UuidEntity;

import com.bizunited.nebula.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "DynamicTaskParamEntity", description = "周期性动态任务可能的传递的参数，支持普通类型或者对象参数转换")
@Entity
@Table(name = "engine_dynamic_params" , indexes = {@Index(columnList = "dynamic_task , param_index")})
public class DynamicTaskParamEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -7525607821759678955L;

  @ApiModelProperty(name="dynamicTask" , value="对应的动态任务", required=true)
  @ManyToOne(fetch = FetchType.LAZY , targetEntity = DynamicTaskSchedulerEntity.class)
  @JoinColumn(name = "dynamic_task" , nullable = false , columnDefinition="varchar(255) COMMENT '对应的动态任务'")
  @SaturnColumn(description = "动态任务")
  private DynamicTaskSchedulerEntity  dynamicTask;
  
  @ApiModelProperty(name="paramType" , value = "参数类型，支持基本类型或者可序列化（json）的对象")
  @Column(name = "param_type" , nullable = false , length = 255 , columnDefinition = "varchar(255) COMMENT '参数类型，支持基本类型或者可序列化（json）的对象'")
  @SaturnColumn(description = "参数类型")
  private String paramType;
  
  @ApiModelProperty(name="paramIndex" , value = "参数索引号，索引号从0开始。索引号必须填写，且不能重复")
  @Column(name = "param_index" , nullable = false, columnDefinition = "int(11) COMMENT '参数索引号，索引号从0开始。索引号必须填写，且不能重复'")
  @SaturnColumn(description = "参数索引号")
  private Integer paramIndex;
  
  @ApiModelProperty(name="paramValue" , value = "参数值,如果是序列化的对象信息，请注意参数长度，可能没有值")
  @Column(name = "param_value" , nullable = true , length = 1024, columnDefinition = "varchar(1024) COMMENT '参数值,如果是序列化的对象信息，请注意参数长度，可能没有值'")
  @SaturnColumn(description = "参数值")
  private String paramValue;

  public DynamicTaskSchedulerEntity getDynamicTask() {
    return dynamicTask;
  }

  public void setDynamicTask(DynamicTaskSchedulerEntity dynamicTask) {
    this.dynamicTask = dynamicTask;
  }

  public String getParamType() {
    return paramType;
  }

  public void setParamType(String paramType) {
    this.paramType = paramType;
  }

  public Integer getParamIndex() {
    return paramIndex;
  }

  public void setParamIndex(Integer paramIndex) {
    this.paramIndex = paramIndex;
  }

  public String getParamValue() {
    return paramValue;
  }

  public void setParamValue(String paramValue) {
    this.paramValue = paramValue;
  }
}
