package com.bizunited.nebula.task.local.repository;

import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.nebula.task.local.repository.internal.DynamicTaskSchedulerLogRepositoryCustom;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * DynamicTaskSchedulerLogEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DynamicTaskSchedulerLogEntityRepository")
public interface DynamicTaskSchedulerLogRepository
    extends
      JpaRepository<DynamicTaskSchedulerLogEntity, String>
      ,JpaSpecificationExecutor<DynamicTaskSchedulerLogEntity>
      , DynamicTaskSchedulerLogRepositoryCustom {
  /**
   * 按照对应的动态日志进行详情查询（包括关联信息），这里查询的是
   * @param id
   * */
  @Query("select distinct dynamicTaskSchedulerLogEntity from DynamicTaskSchedulerLogEntity dynamicTaskSchedulerLogEntity "
      + " left join fetch dynamicTaskSchedulerLogEntity.dynamicTaskScheduler dynamicTaskSchedulerLogEntity_dynamicTaskScheduler "
       + " where dynamicTaskSchedulerLogEntity_dynamicTaskScheduler.id = :taskId order by dynamicTaskSchedulerLogEntity.startTime desc")
  public Set<DynamicTaskSchedulerLogEntity> findDetailsByDynamicTask(@Param("taskId") String taskId);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   * @param id 主键
   * */
  @Query("select distinct dynamicTaskSchedulerLogEntity from DynamicTaskSchedulerLogEntity dynamicTaskSchedulerLogEntity "
      + " left join fetch dynamicTaskSchedulerLogEntity.dynamicTaskScheduler dynamicTaskSchedulerLogEntity_dynamicTaskScheduler "
      + " where dynamicTaskSchedulerLogEntity.id=:id ")
  public DynamicTaskSchedulerLogEntity findDetailsById(@Param("id") String id);
  /**
   * 按照指定的动态任务数据库编码，真删除其下所有的日志信息
   */
  @Modifying
  @Query(value="delete from engine_dynamic_task_log where dynamic_task = :dynamicTaskId" , nativeQuery = true)
  public void deleteByDynamicTaskId(@Param("dynamicTaskId") String dynamicTaskId);
}