package com.bizunited.nebula.task.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerLogDto;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerLogEntity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yinwenjie
 */
@Repository("DynamicTaskSchedulerLogRepositoryImpl")
public class DynamicTaskSchedulerLogRepositoryImpl implements DynamicTaskSchedulerLogRepositoryCustom , PageRepositoryImpl {
  
  /**
   * 日志
   */
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  
  @Override
  public Page<DynamicTaskSchedulerLogEntity> findByConditions(Pageable pageable, DynamicTaskSchedulerLogDto conditions) {
    /*
     * -按照任务id编号(一定有)、日志类型、日志时间（只有一个，这里要自行计算开始和结束时间）
     * */
    StringBuilder hql = new StringBuilder("from DynamicTaskSchedulerLogEntity dtl inner join fetch dtl.dynamicTaskScheduler dt where 1 = 1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from engine_dynamic_task_log dtl inner join dtl.dynamicTaskScheduler dt where 1 = 1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    // 任务技术编号
    if(StringUtils.isNoneBlank(conditions.getTaskId())) {
      condition.append(" AND dt.id = :taskId ");
      parameters.put("taskId", conditions.getTaskId());
    }
    // 应用名
    if(StringUtils.isNotBlank(conditions.getApplicationName())) {
      condition.append(" AND dt.applicationName = :applicationName ");
      parameters.put("applicationName", conditions.getApplicationName());
    }
    // 一级租户
    if(StringUtils.isNotBlank(conditions.getAppCode())) {
      condition.append(" AND dt.appCode = :appCode ");
      parameters.put("appCode", conditions.getAppCode());
    }
    // 日志时间
    if(conditions.getLogtime() != null) {
      condition.append(" AND dtl.startTime >= :startTime AND dtl.startTime <= :endTime ");
      parameters.put("appCode", conditions.getAppCode());
      String logtimeValue = conditions.getLogtime().toString();
      String startTimeValue = StringUtils.join(logtimeValue, " 00:00:00");
      String endTimeValue = StringUtils.join(logtimeValue, " 23:59:59");
      SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Date startTime;
      Date endTime;
      try {
        startTime = dataFormat.parse(startTimeValue);
        endTime = dataFormat.parse(endTimeValue);
      } catch (ParseException e) {
        throw new IllegalArgumentException(e);
      }
      parameters.put("startTime", startTime);
      parameters.put("endTime", endTime);
    }
    // 日志类型
    if(conditions.getSuccess() != null) {
      condition.append(" AND dtl.success = :success ");
      parameters.put("success", conditions.getSuccess());
    }
    
    hql.append(condition).append(" order by dt.createTime desc  ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}