package com.bizunited.nebula.task.local.service.internal;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bizunited.nebula.task.local.entity.DynamicTaskParamEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskParamRepository;
import com.bizunited.nebula.task.local.service.DynamicTaskParamService;

@Service("DynamicTaskParamServiceImpl")
public class DynamicTaskParamServiceImpl implements DynamicTaskParamService {

  @Autowired
  private DynamicTaskParamRepository dynamicTaskParamRepository;
  
  @Override
  public List<DynamicTaskParamEntity> findByDynamicTask(String dynamicTaskId) {
    if(StringUtils.isBlank(dynamicTaskId)) {
      return null;
    }
    return this.dynamicTaskParamRepository.findByDynamicTask(dynamicTaskId);
  }
}
