package com.bizunited.nebula.task.local.service.internal;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.bizunited.nebula.task.local.entity.DynamicTaskParamEntity;
import com.bizunited.nebula.task.local.service.DynamicTaskParamService;
import com.bizunited.nebula.task.service.DynamicTaskParamVoService;
import com.bizunited.nebula.task.service.strategy.DynamicTaskParamValueConverter;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import com.google.common.collect.Lists;

@Service("_DynamicTaskParamVoServiceImpl")
public class DynamicTaskParamVoServiceImpl implements DynamicTaskParamVoService {
  @Autowired
  private ApplicationContext applicationContext;
  @Autowired
  private DynamicTaskParamService dynamicTaskParamService;
  @Autowired(required = false)
  private List<DynamicTaskParamValueConverter> dynamicTaskParamValueConverters;
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskParamVoServiceImpl.class);
  
  @Override
  public List<DynamicTaskParamVo> findByDynamicTask(String dynamicTaskId) {
    List<DynamicTaskParamEntity> dynamicTaskParams = this.dynamicTaskParamService.findByDynamicTask(dynamicTaskId);
    if(CollectionUtils.isEmpty(dynamicTaskParams)) {
      return null;
    }
    ClassLoader classLoader = applicationContext.getClassLoader();
    // 首先找到默认转换器
    DynamicTaskParamValueConverter defaultDynamicTaskParamValueConverter = dynamicTaskParamValueConverters.stream().filter(item -> item.isDefault()).findFirst().orElse(null);
    
    // ======== 开始进行转换
    List<DynamicTaskParamVo> results = Lists.newArrayList();
    for(int index = 0 ; index < dynamicTaskParams.size() ; index ++) {
      DynamicTaskParamEntity dynamicTaskParam = dynamicTaskParams.get(index);
      String paramTypeValue = dynamicTaskParam.getParamType();
      // 转换成class
      Class<?> paramTypeClass = null;
      try {
        paramTypeClass = classLoader.loadClass(paramTypeValue);
      } catch(ClassNotFoundException e) {
        LOGGER.error(e.getMessage() , e);
        throw new IllegalArgumentException(e.getMessage());
      }
      String paramValue = dynamicTaskParam.getParamValue();
      Object deserialize = null;
      // 如果条件成立，说明需要转换参数值
      if(paramValue != null) {
        boolean canConverter = false;
        DynamicTaskParamValueConverter currntDynamicTaskParamValueConverter = null;
        for (DynamicTaskParamValueConverter dynamicTaskParamValueConverter : dynamicTaskParamValueConverters) {
          if(canConverter = dynamicTaskParamValueConverter.canConverter(index, paramTypeClass)) {
            currntDynamicTaskParamValueConverter = dynamicTaskParamValueConverter;
            break;
          }
        }
        // 如果条件成立，则使用默认制转换器
        if(!canConverter) {
          currntDynamicTaskParamValueConverter = defaultDynamicTaskParamValueConverter;
        }
        // 开始进行转换
        deserialize = currntDynamicTaskParamValueConverter.deserialize(index, paramTypeClass, paramValue);
      }
      
      // 创建VO
      DynamicTaskParamVo dynamicTaskParamVo = new DynamicTaskParamVo();
      dynamicTaskParamVo.setId(dynamicTaskParam.getId());
      dynamicTaskParamVo.setParamIndex(index);
      dynamicTaskParamVo.setParamType(paramTypeClass);
      dynamicTaskParamVo.setParamValue(deserialize);
      results.add(dynamicTaskParamVo);
    }   
    
    return results;
  }
}
